<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once (PATH_THIRD.'single_mailinglist_mailchimp/mailchimp/MailChimp.php'); 
  use \DrewM\MailChimp\MailChimp;	

use EllisLab\ExpressionEngine\Library\CP\Table;
/**
 * Single Mailing List Control Panel File 
 *
 * @package		ExpressionEngine
 * @subpackage	Addons
 * @category	Module
 * @author		W3Care DevTeam
 * @link		hppts://www.w3care.com
 * @edit date	12/28/2020
 */

class Single_mailinglist_mailchimp_mcp {
	
	public $return_data; 
	private $base_url;
	private $documentation_url;
	private $perpage;
	/**
	** Constructor **
	**/
	public function __construct() 
	{ 
		$instance = get_instance();
		$this->EE =& $instance;
				
		$this->base_url = ee('CP/URL')->make('addons/settings/single_mailinglist_mailchimp');

		$this->map_mailchimp = ee('CP/URL')->make('addons/settings/single_mailinglist_mailchimp/map_mailchimp');
		
		$this->confiqure_newsletter = ee('CP/URL')->make('addons/settings/single_mailinglist_mailchimp/confiqure_newsletter');

		$sidebar = ee('CP/Sidebar')->make();

		$header = $sidebar->addHeader(lang('Mailchimp Newsletter'));		  

		$item_list = $header->addBasicList();

		$item_list->addItem(lang('subscription_list'), $this->base_url);

		$item_list->addItem(lang('mailchimp_settings'), $this->map_mailchimp);
		
		$item_list->addItem(lang('newsletter_template'), $this->confiqure_newsletter);
		
		ee()->cp->add_to_head('<link href="'.URL_THIRD_THEMES.'single_mailinglist_mailchimp/css/single_mailinglist.css" rel="stylesheet" type="text/css" />');
	}
	  
	function cp_url ($action = 'index', $variables = array()) {		
		$url = cp_url('cp/addons/settings/single_mailinglist_mailchimp/'.$action);	
		foreach ($variables as $variable => $value) {
			$url .= AMP . $variable . '=' . $value;
		}		
		return $url;
	}  
	
	/**
	** Index Function **
	**/
	function index()
	  {
	
		$data = array();
		$base_url = ee('CP/URL', 'addons/settings/single_mailinglist_mailchimp');
		ee()->load->library('table');
		
		if(!empty(ee()->input->get_post('email_address'))){
			$filter_email = ee()->input->get_post('email_address');
		}
		else{
			$filter_email = ee()->input->get_post('email');
		}
		if(!empty(ee()->input->get_post('ip'))){
			$ip = ee()->input->get_post('ip');
		}
		else{
			$ip = ee()->input->get_post('ip_address');
		}

		$date = ee()->input->get_post('date');
		$status = ee()->input->get_post('status');
		ee()->cp->add_js_script(
		array('ui' => array(
		'core', 'datepicker'
		)
		));
		ee()->javascript->output('
			$("#date").datepicker({
			dateFormat: "yy-mm-dd",
			});
			
		  function cleaform(){
		   $("#date").val("");
         }
		 
		 $("#filter-form").submit(function () {
				window.localStorage["text1_val"] = $("input[name = email_address]").val();
				window.localStorage["text2_val"] = $("input[name = date]").val();
				window.localStorage["text3_val"] = $("input[name = ip]").val();
				window.localStorage["text4_val"] = $("select[name = status]").val();
			});
			
		$(window).load(function () {
			$("input[name = email_address]").val(window.localStorage["text1_val"]);
			$("input[name = hidden_email_address]").val(window.localStorage["text1_val"]);
			$("input[name = date]").val(window.localStorage["text2_val"]);
			$("input[name = hidden_date]").val(window.localStorage["text2_val"]);
			$("input[name = ip]").val(window.localStorage["text3_val"]);
			$("input[name = hidden_ip]").val(window.localStorage["text3_val"]);
			$("select[name = status]").val(window.localStorage["text4_val"]);
			$("input[name = hidden_status]").val(window.localStorage["text4_val"]);
							
		});
		
		$( ".pagi" ).click(function() {
				var hidden_email = $("#hidden_email_address").val();
				var hidden_date = $("#hidden_date").val();
				var hidden_ip = $("#hidden_ip").val();
				var status = $("#hidden_status").val();
				var url = $(this).attr("href");
				if(hidden_email !== "undefined" && hidden_email !== ""){
					var add_url1 = "&email="+hidden_email+"";
				}else{
					var add_url1 = "";
				}
				
				if(hidden_date !== "undefined" && hidden_date !== ""){
					var add_url2 = "&filter_date="+hidden_date+"";
				}else{
					var add_url2 = "";
				}
				
				if(hidden_ip !== "undefined" && hidden_ip !== ""){
					var add_url3 = "&ip_address="+hidden_ip+"";
				}else{
					var add_url3 = "";
				}
				
				if(status !== "undefined" && status !== ""){
					var add_url4 = "&status="+status+"";
				}else{
					var add_url4 = "";
				}
				$("a[href="+url+"]").attr("href", url+add_url1+add_url2+add_url3+add_url4)
			});
			
			$( ".sort" ).click(function() {
				var hidden_email = $("#hidden_email_address").val();
				var hidden_date = $("#hidden_date").val();
				var hidden_ip = $("#hidden_ip").val();
				var status = $("#hidden_status").val();
				var url = $(this).attr("href");
				//alert(url);
				if(hidden_email !== "undefined" && hidden_email !== ""){
					var add_url1 = "&email="+hidden_email+"";
				}else{
					var add_url1 = "";
				}
				
				if(hidden_date !== "undefined" && hidden_date !== ""){
					var add_url2 = "&filter_date="+hidden_date+"";
				}else{
					var add_url2 = "";
				}
				
				if(hidden_ip !== "undefined" && hidden_ip !== ""){
					var add_url3 = "&ip_address="+hidden_ip+"";
				}else{
					var add_url3 = "";
				}
				
				if(status !== "undefined" && status !== ""){
					var add_url4 = "&status="+status+"";
				}else{
					var add_url4 = "";
				}
				$("a[href="+url+"]").attr("href", url+add_url1+add_url2+add_url3+add_url4)
			});
  
        ');
		
		$where_limit = '';
		$where = '';
		if(!empty($filter_email) || !empty($date) || !empty($ip) || !empty($status)){ 
			//$where = array();
			if(!empty($filter_email)){
				if(!empty($filter_email) && !empty($date) || !empty($ip) || !empty($status)){
					$where_limit .= "email_id LIKE '%".$filter_email."%'  AND ";
				}else{
					$where_limit .= "email_id LIKE '%".$filter_email."%'";
				}
			}
			if(!empty($date)){
				if(!empty($date) && !empty($ip) || !empty($status)){
						$where_limit .= "date = '".$date."' AND ";
					}else{
						$where_limit .= "date = '".$date."'";
					}
			}
			if(!empty($ip)){
				if(!empty($ip) && !empty($status)){
					$where_limit .= "ip_address = '".$ip."' AND ";
				}else{
					$where_limit .= "ip_address = '".$ip."'";
				}
			}
			if(!empty($status)){
				$where_limit .= "status = '".$status."'";
			}
		  	$t = ee()->db->select('*')
						->from('mailing_list')
						->where($where_limit)
						->get();
		}
		else{
			$t = ee()->db->select('*')
						->from('mailing_list')
						->get();
		}
		
		$total = $t->num_rows();
		$per_page = ((int) ee()->input->get_post('per_page')) ?: 10;
		$currentPage = ee()->input->get_post('page')?:1;
		$offset = ee()->input->get('tbl_offset') ?: 0;

		if(!empty($filter_email) || !empty($date) || !empty($ip) || !empty($status)){ 
			if(!empty($filter_email)){
				if(!empty($filter_email) && !empty($date) || !empty($ip) || !empty($status)){
					$where .= "email_id LIKE '%".$filter_email."%'  AND ";
				}else{
					$where .= "email_id LIKE '%".$filter_email."%'";
				}
			}
			if(!empty($date)){
				if(!empty($date) && !empty($ip) || !empty($status)){
						$where .= "date = '".$date."' AND ";
					}else{
						$where .= "date = '".$date."'";
					}
			}
			if(!empty($ip)){
				if(!empty($ip) && !empty($status)){
					$where .= "ip_address = '".$ip."' AND ";
				}else{
					$where .= "ip_address = '".$ip."'";
				}
			}
			if(!empty($status)){
				$where .= "status = '".$status."'";
			}
		
		  	$q = ee()->db->select('*')
							->from('mailing_list')
							->where($where)
							->limit($per_page)
							->offset($offset)
							->get();
		}
		else{
			$q = ee()->db->select('*')
							->from('mailing_list')
							->limit($per_page)
							->offset($offset)
							->get();
		}
	    if($q->num_rows()>0)
		{
			$vars['setting_check'] = $q->result_array();
			foreach($vars['setting_check'] as $settingcheck2)
			{
				$vars['settingcheck2'][] = $settingcheck2;
				$uid 		           = $settingcheck2['id']; 
				$email_id             =  $settingcheck2['email_id']; 
				$date         =  $settingcheck2['date']; 
				$ip_address         =  $settingcheck2['ip_address']; 
				$status         =  $settingcheck2['status']; 
				$checkbox = array(
					'name' => 'selection[]',
					'value' => $settingcheck2['id'],
					'data'	=> array(
					'confirm' => lang('toolset') . ': <b>' . htmlentities(''.$email_id.'', ENT_QUOTES, 'UTF-8') . '</b>'
					)
				);

				$email = $settingcheck2['email_id'];
				$checkbox['enabled'] = 'enabled';

				$toolset = array(
					'email_id' => $email,
					'date' => $settingcheck2['date'],
					'ip_address' => $settingcheck2['ip_address'],
					'status' => $settingcheck2['status'],
					$checkbox
				);
				$data[] = array(
					'attrs' => array('label' => 'Subscription'),
					'columns'	=> $toolset
				);
				$table = ee('CP/Table', array('autosort' => TRUE, 'autosearch' => FALSE, 'limit' => 10));
				$table->setColumns(
					array(
					'email',
					'date',
					'ip_address',
					'status',
					array(
						'type'	=> Table::COL_CHECKBOX
					)
					)
				);
				
				$table->setNoResultsText('no_results');
				$table->setData($data);
				$vars['table'] = $table->viewData($base_url);
			}
		}  
		$vars['pagination'] = array(
			'per_page' => $per_page,
			'total_rows' => $total 
		);
		///////////Adding pgination 
		$config = array(
			'base_url'				=> '',
			'per_page'				=> $per_page,
			'cur_page'				=> $offset,
			'num_links'				=> 2,
			'full_tag_open'			=> '<div class="paginate"><ul>', 
			'full_tag_close'		=> '</ul></div>',
		);
		$config = array_merge($config, $vars['pagination']);
		ee()->load->library('pagination');
		ee()->pagination->initialize($config);
		$links = ee()->pagination->create_link_array();	

		if($links){
			foreach ($links as &$section)
			{
				foreach ($section as &$link)
				{
					if (empty($link)) continue;

					$url = clone $base_url;
					$offset = str_replace('/', '', $link['pagination_url']);
					if ( ! empty($offset))
					{
						$url->setQueryStringVariable('tbl_offset', $offset);
						$url->setQueryStringVariable('per_page', $per_page);
					}					
					$link['pagination_url'] = $url->compile();
				}
			}
		}
		$vars['pagination_links'] = $links ;
	    	
		
		ee()->javascript->set_global('lang.remove_confirm', lang('newsletter') . ': <b>### ' . lang('newsletter') . '</b>');
		ee()->cp->add_js_script(array(
			'file' => array('cp/confirm_remove'),
		));
		
		return ee('View')->make('single_mailinglist_mailchimp:index')->render($vars);
	  }
		
	public function map_mailchimp()
	{
		$vars = array();
		$vars['form_action'] = ee('CP/URL')->make('addons/settings/single_mailinglist_mailchimp/save_settings_mailchimp_newsletter');
		$q = ee()->db->select('*')
				->from('mailchimp_mailing_settings')
				->get();
			if($q->num_rows() > 0)
			{
				$vars['mailchimp_api'] =  $q->row('mailchimp_api');
				$vars['list_id_1'] =  $q->row('list_id_1');
				$vars['template_id'] =  $q->row('template_id');
				$vars['mc_template_class'] =  $q->row('mc_template_class');
				$vars['selected_template_group'] =  $q->row('selected_template_group');
			}else{
				$vars['mailchimp_api'] = '';
				$vars['list_id_1'] = '';
				$vars['template_id'] = '';
				$vars['mc_template_class'] = '';
				$vars['selected_template_group'] = '';
			}
		$rs2 = ee()->db->select('group_id, group_name')
				->from('template_groups')
				->get();
		$fielddata[0] = 'Newsletter Template Group';
		if($rs2->num_rows() > 0){
			foreach($rs2->result_array() as $row2){	
				$fielddata[$row2['group_id']] = $row2['group_name']; 		
			}
		}
		$vars['fielddata'] = $fielddata;
		ee()->cp->add_to_foot('<script type="text/javascript" src="'.URL_THIRD_THEMES.'single_mailinglist_mailchimp/js/jquery.validate.min.js"></script>');
		ee()->cp->add_to_foot('<script type="text/javascript">
		$(".map_mailchimp").validate({
    rules: {
      api_field: "required",
      list_id_1: "required",
			template_id: "required",
			mc_template_class: "required",
    },
    // Specify validation error messages
    messages: {
      api_field: "Please Add Api",
      list_id_1: "Please Add Mailchimip List ID",
      template_id: "Please Add Mailchimip Template ID",
			mc_template_class: "Please Add Mailchimip Template Class"
    },
		
    // Make sure the form is submitted to the destination defined
    // in the "action" attribute of the form when valid
    submitHandler: function(form) {
      form.submit();
    }
  });
	</script>');
		return ee()->load->view('map_mailchimp', $vars, TRUE);
	}
	
	
	public function save_settings_mailchimp_newsletter(){

	$mailchimp_api = ee()->input->post('api_field');
	$list_id_1 = ee()->input->post('list_id_1');
	$template_id = ee()->input->post('template_id');
	$mc_template_class = ee()->input->post('mc_template_class');
	$selected_template_group = ee()->input->post('selected_template_group');
	$mapped_fields=array('mailchimp_api'=>$mailchimp_api,'list_id_1'=>$list_id_1,'template_id'=>$template_id,'mc_template_class'=>$mc_template_class,'selected_template_group'=>$selected_template_group);
	$insert_records = ee()->db->select('ID')
		->from('mailchimp_mailing_settings')
		->get();

	if($insert_records->num_rows() > 0){
		ee()->db->where('ID', 1);
		ee()->db->update('mailchimp_mailing_settings',$mapped_fields);
	}else{
		ee()->db->insert('mailchimp_mailing_settings',$mapped_fields);
	}

		/*END--update mapped field*/
		ee()->session->set_flashdata('message_success', ee()->lang->line('settings_updated'));
		ee()->functions->redirect($this->cp_url('map_mailchimp'));
		}
	
	public function confiqure_newsletter(){
		$vars = array();
		$vars['form_action'] = ee('CP/URL')->make('addons/settings/single_mailinglist_mailchimp/send_newsletter');
		$q = ee()->db->select('selected_template_group, selected_template')
				->from('mailchimp_mailing_settings')
				->get();
				
		if($q->num_rows() > 0)
			{
				/*getting templates by assigned template group*/
				$rs2 = ee()->db->select('template_id, template_name')
							->from('templates')
							->where('group_id', $q->row('selected_template_group'))
							->get();
				$fielddata[0] = 'Select Template';
					if($rs2->num_rows() > 0){
						foreach($rs2->result_array() as $row2){	
						$fielddata[$row2['template_id']] = $row2['template_name']; 		
					}
				}
				$vars['templatedata'] = $fielddata;
				
				/*Get action ID of import URL*/
				$q_act = ee()->db->select('action_id')
				->from('actions')
				->where('method', 'fetch_template')
				->get();
				
				/*getting last saved template data*/
				$vars['selected_template'] = '0';
				$vars['selected_template_data'] = '';
				if($q->row('selected_template') && $q->row('selected_template_group')){
					$selected_tem = ee()->db->select('template_data')
							->from('templates')
							->where('template_id', $q->row('selected_template'))
							->where('group_id', $q->row('selected_template_group'))
							->get();
					if($selected_tem->num_rows() > 0){
					$vars['selected_template'] = $q->row('selected_template');
					$vars['selected_template_data'] = $selected_tem->row('template_data');
					}
					else{
						$vars['selected_template'] = '0';
						$vars['selected_template_data'] = '';
						}
				}
			$vars['fetch_template_action'] = ee()->config->item('site_url').'?ACT='.$q_act->row('action_id');
			}
		else{
			$vars['selected_template'] = '0';
			$vars['selected_template_data'] = '';
			$vars['templatedata'] = '';
			$vars['fetch_template_action'] = '';
			}
			$vars['adminname'] = ee()->config->item('webmaster_name');
			$vars['adminemail'] = ee()->config->item('webmaster_email');
			$vars['sitename'] = ee()->config->item('site_name');
		//$csrf_toekn = EE.CSRF_TOKEN;
		ee()->cp->add_to_foot('<script type="text/javascript" src="'.URL_THIRD_THEMES.'single_mailinglist_mailchimp/js/jquery.validate.min.js"></script>');
		ee()->cp->add_to_foot('<script type="text/javascript">
		function fetch_template(){
			var selectedTemplate = $(".selected_template option:selected").val();
			var fetchTemplateURL = $("#fetch_template").attr("value");
				$.ajax({
        type: "POST",
        url: fetchTemplateURL,
        data: ({ template_id : selectedTemplate , csrf_toekn : EE.CSRF_TOKEN}),
        dataType: "html",
        success: function(data) {
						$("#news_letter_content").val(data);
        }
    });
			
		}
		$(".newsletter_form").validate({
    rules: {
      from_name: "required",
      mail_subject: "required",
      reply_to: {
        required: true,
        // Specify that email should be validated
        // by the built-in "email" rule
        email: true
      },
			news_letter_content: "required",
    },
    // Specify validation error messages
    messages: {
      from_name: "Please Add From Name",
      mail_subject: "Please Add Newsletter Subject",
      reply_to: "Please Add a Valid Reply to Address",
			news_letter_content: "Please Add Newsletter Content"
    },
		
    // Make sure the form is submitted to the destination defined
    // in the "action" attribute of the form when valid
    submitHandler: function(form) {
      form.submit();
    }
  });

</script>');
		return ee()->load->view('configure_newsletter', $vars, TRUE);
		}
		
	public function send_newsletter(){
			$vars = array();
			$reply_to = ee()->input->get_post('reply_to');
			$mail_subject = ee()->input->get_post('mail_subject');
			$from_name = ee()->input->get_post('from_name');
			$news_letter_content = ee()->input->get_post('news_letter_content');
			$selected_template = ee()->input->get_post('selected_template');
			$mapped_fields=array('selected_template'=>$selected_template);
			ee()->db->where('ID', 1);
			ee()->db->update('mailchimp_mailing_settings',$mapped_fields);
			
			$q = ee()->db->select('*')
				->from('mailchimp_mailing_settings')
				->get();
				$mailchimp_api =  $q->row('mailchimp_api');
				$list_id_1 =  $q->row('list_id_1');
				$template_id =  intval($q->row('template_id'));
				$mc_template_class =  $q->row('mc_template_class');
			
			
			$mailchimpid_new = $mailchimp_api;	 
			
			$html1='<div mc:edit="'.$mc_template_class.'">';
			$html1 .= $news_letter_content;
			$html1 .= '</div>';		 
			
			$MailChimp = new MailChimp($mailchimpid_new);
			
			$result = $MailChimp->post('campaigns', array('type'=>'regular','recipients' =>array('list_id'=>$list_id_1),'settings'=>array('subject_line'=>$mail_subject,'inline_css' =>true,'reply_to'=>$reply_to,'from_name'=>$from_name)));
		 
			$result2 = $MailChimp->put('campaigns/'.$result['id'].'/content', array('template' => array('id' =>$template_id, 'sections' => array($mc_template_class => $html1)))); 
		 
			//$result3 = $MailChimp->post('campaigns/5f0d6ab6ae/actions/send');	
			$result3 = $MailChimp->post('campaigns/'.$result['id'].'/actions/send');
			ee()->functions->redirect($this->cp_url('confiqure_newsletter'));
			}  
		
		
	public function update_data()
		{
		 $action = ee()->input->post('bulk_action');
		 $selection = ee()->input->post('selection');
		 $mailing_list = array();
		
		 $mailing_list = array();
		switch ($action)
		{
			case 'remove':

				$message_title = '';
				$message_desc = '';
				
				foreach ($selection as $mailing_id)
				{
					ee()->db->where('id', $mailing_id)
				         ->delete('mailing_list');
				    $removed = ee()->db->affected_rows();
						if ( ! $removed)
						{
							//$errors[] = $mailing_list[$mailing_id];
							$errors[] = "Email ID(s) not removed, contact vendor";
						}
						else
						{
							//$successes[] = $mailing_list[$mailing_id];
							$successes[] = "Email ID(s) removed from subscription";
						}
					
				}
				break;
			case 'export':
				  header('Content-Type: text/csv; charset=utf-8');  
				  header('Content-Disposition: attachment; filename=data.csv');  
				  $output = fopen("php://output", "w");  
				  fputcsv($output, array('ID','Email_id', 'Date', 'IP Adress', 'Status'));  
								  
				foreach ($selection as $mailing_id)
				{  
				
					  $q = ee()->db->select('*')
								->from('mailing_list')
								->where('id',$mailing_id)
								->get();
					  
					  if($q->num_rows()>0)
					  {
						 $vars['setting_check'] = $q->result_array();						 
						 foreach($vars['setting_check'] as $settingcheck2)
						{
						   $record_ids[] = $settingcheck2['id'];
						   $vars['settingcheck2'][] = $settingcheck2;
						   fputcsv($output, $settingcheck2);
						}						
					 }
				}
				//$this->_addExported($record_ids);
				 exit;
			break;
		}
		
	   ee()->functions->redirect($this->cp_url());
	  }
	  
	  function _addExported(array $ids){
		  $ids_in = implode('|',$ids);
		  foreach($ids as $id){
			$q = ee()->db->update(
				'mailing_list',
				array(
					'status'  => 'Exported'				
				),
				array(
					'id' => $id 
				)
			);	  
		  }	
	  }
 			
}
/* End of file mcp.single_mailinglist_mailchimp.php */
/* Location: /system/user/addons/single_mailinglist_mailchimp/mcp.single_mailinglist_mailchimp.php */