<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * @author		Rein de Vries <support@reinos.nl>
 * @link		https://addons.reinos.nl
 * @copyright 	Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * @license     https://addons.reinos.nl/commercial-license
 *
 * Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * All rights reserved.
 *
 * This source is commercial software. Use of this software requires a
 * site license for each domain it is used on. Use of this software or any
 * of its source code without express written permission in the form of
 * a purchased commercial or other license is prohibited.
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 *
 * As part of the license agreement for this software, all modifications
 * to this source must be submitted to the original author for review and
 * possible inclusion in future releases. No compensation will be provided
 * for patches, although where possible we will attribute each contribution
 * in file revision notes. Submitting such modifications constitutes
 * assignment of copyright to the original author (Rein de Vries and
 * Reinos.nl Internet Media) for such modifications. If you do not wish to assign
 * copyright to the original author, your license to  use and modify this
 * source is null and void. Use of this software constitutes your agreement
 * to this clause.
 */

//updates
$this->updates = array(
	//'1.2',
);

//Default Post
$this->default_post = array(
    'license_key' => '',
    'license_reinos_member_id' => '',
    'license_valid' => false,
    'license_report_date' => time(),
    'log_severity' => 'errors',

    'debug_mode' => false,
);

//overrides
$this->overide_settings = array(
	//'gmaps_icon_dir' => '[theme_dir]images/icons/',
	//'gmaps_icon_url' => '[theme_url]images/icons/',
);

// Backwards-compatibility with pre-2.6 Localize class
$this->format_date_fn = (version_compare(APP_VER, '2.6', '>=')) ? 'format_date' : 'decode_date';

//show the field in wide or default
$this->field_wide = true;

//based on https://docs.expressionengine.com/latest/development/shared_form_view.html
$this->fieldtype_settings = array(
    array(
        'label' => lang('Preset'),
        'name' => 'preset',
        'desc' => 'Presets can be created in the Iconfont CP section',
        'type' => 'select',
        'choices' => 'service:preset|method:getPresets',
        'def_value' => '',
        'global' => false,
    ),
);

$this->mysql_table_data = array(
    'settings' => array(
        'keys' => array(
            array('settings_id', true), //primary
            //array('field_name'),
        ),
        'fields' => array(
            'settings_id'	=> array(
                'type'			=> 'int',
                'constraint'		=> 7,
                'unsigned'		=> TRUE,
                'null'			=> FALSE,
                'auto_increment'	=> TRUE
            ),
            'site_id'  => array(
                'type'			=> 'int',
                'constraint'		=> 7,
                'unsigned'		=> TRUE,
                'null'			=> FALSE,
                'default'			=> 0
            ),
            'var'  => array(
                'type' 			=> 'varchar',
                'constraint'		=> '200',
                'null'			=> FALSE,
                'default'			=> ''
            ),
            'value'  => array(
                'type' 			=> 'text'
            ),
        )
    ),
    'logs' => array(
        'keys' => array(
            array('log_id', true), //primary
            //array('field_name'),
        ),
        'fields' => array(
            'log_id'	=> array(
                'type'			=> 'int',
                'constraint'		=> 7,
                'unsigned'		=> TRUE,
                'null'			=> FALSE,
                'auto_increment'	=> TRUE
            ),
            'site_id'  => array(
                'type'			=> 'int',
                'constraint'		=> 7,
                'unsigned'		=> TRUE,
                'null'			=> FALSE,
                'default'			=> 0
            ),
            'severity'  => array(
                'type' 			=> 'varchar',
                'constraint'		=> '200',
                'null'			=> FALSE,
                'default'			=> 'notice'
            ),
            'time'  => array(
                'type'			=> 'int',
                'constraint'		=> 10,
                'unsigned'		=> TRUE,
                'null'			=> FALSE,
                'default'			=> 0
            ),
            'message'  => array(
                'type' 			=> 'text'
            ),
        )
    ),
    'presets' => array(
        'keys' => array(
            array('preset_id', true), //primary
        ),
        'fields' => array(
            'preset_id'	=> array(
                'type'			=> 'int',
                'constraint'		=> 7,
                'unsigned'		=> TRUE,
                'null'			=> FALSE,
                'auto_increment'	=> TRUE
            ),
            'site_id'  => array(
                'type'			=> 'int',
                'constraint'		=> 7,
                'unsigned'		=> TRUE,
                'null'			=> FALSE,
                'default'			=> 0
            ),
            'name'  => array(
                'type' 			=> 'varchar',
                'constraint'		=> '200',
                'null'			=> FALSE,
                'default'			=> 'notice'
            ),
            'provider'  => array(
                'type' 			=> 'varchar',
                'constraint'		=> '200',
                'null'			=> FALSE,
                'default'			=> 'notice'
            ),
            'json_preset'  => array(
                'type' 			=> 'text'
            ),
            'custom_css_url'  => array(
                'type' 			=> 'text'
            ),
        )
    ),
);
