<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * @author		Rein de Vries <support@reinos.nl>
 * @link		https://addons.reinos.nl
 * @copyright 	Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * @license     https://addons.reinos.nl/commercial-license
 *
 * Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * All rights reserved.
 *
 * This source is commercial software. Use of this software requires a
 * site license for each domain it is used on. Use of this software or any
 * of its source code without express written permission in the form of
 * a purchased commercial or other license is prohibited.
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 *
 * As part of the license agreement for this software, all modifications
 * to this source must be submitted to the original author for review and
 * possible inclusion in future releases. No compensation will be provided
 * for patches, although where possible we will attribute each contribution
 * in file revision notes. Submitting such modifications constitutes
 * assignment of copyright to the original author (Rein de Vries and
 * Reinos.nl Internet Media) for such modifications. If you do not wish to assign
 * copyright to the original author, your license to  use and modify this
 * source is null and void. Use of this software constitutes your agreement
 * to this clause.
 */

/**
 * Include the config file
 */
require_once PATH_THIRD.'reinos_iconfont/config.php';

class Reinos_iconfont {

	// ----------------------------------------------------------------------

	/**
	 * Constructor
	 */
	public function __construct()
	{
		//require the default settings
		require PATH_THIRD.REINOS_ICONFONT_MAP.'/settings.php';
	}

	// ----------------------------------------------------------------------------------

	/**
	 * the Actions
	 *
	 * @return unknown_type
	 */
	public function act_route()
	{
		//needed in some cases
		header('Access-Control-Allow-Origin: *');

		// Load Library
		if (class_exists(REINOS_ICONFONT_CLASS.'_ACT') != TRUE) include 'act.'.REINOS_ICONFONT_MAP.'.php';

		//set the class name
		$class = REINOS_ICONFONT_CLASS.'_ACT';

		//call it
		$ACT = new $class;

		$ACT->init();

		exit;
	}

	// ----------------------------------------------------------------

	public function __call($name, $args)
	{
		$class = '\\Reinos\\'.REINOS_ICONFONT_NAMESPACE_CLASS.'\\Core\\Tag\\' . ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->studlyCase($name);

		//class not exists
		if (class_exists($class) === false) {
			ee()->TMPL->log_item("Tag Not Processed: Method Inexistent or Module Not Installed");

			$error  = ee()->lang->line('error_tag_module_processing');
			$error .= '<br /><br />';
			$error .= htmlspecialchars(LD);
			$error .= 'exp:'.REINOS_ICONFONT_MAP.':'.$name;
			$error .= htmlspecialchars(RD);
			$error .= '<br /><br />';
			$error .= str_replace('%x', REINOS_ICONFONT_MAP, str_replace('%y', $name, ee()->lang->line('error_fix_module_processing')));
			ee()->output->fatal_error($error);
		}

		//call the class
		if (empty($args)) {
			$tag = new $class(ee()->TMPL->tagdata, ee()->TMPL->tagparams);
		} else {
			$tag = new $class($args[0], $args[1]);
		}

		//return it when calling the parse function
		return $tag->parse();
	}

}
