<?php if (!defined('BASEPATH')) die('No direct script access allowed');

/**
 * @author		Rein de Vries <support@reinos.nl>
 * @link		https://addons.reinos.nl
 * @copyright 	Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * @license     https://addons.reinos.nl/commercial-license
 *
 * Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * All rights reserved.
 *
 * This source is commercial software. Use of this software requires a
 * site license for each domain it is used on. Use of this software or any
 * of its source code without express written permission in the form of
 * a purchased commercial or other license is prohibited.
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 *
 * As part of the license agreement for this software, all modifications
 * to this source must be submitted to the original author for review and
 * possible inclusion in future releases. No compensation will be provided
 * for patches, although where possible we will attribute each contribution
 * in file revision notes. Submitting such modifications constitutes
 * assignment of copyright to the original author (Rein de Vries and
 * Reinos.nl Internet Media) for such modifications. If you do not wish to assign
 * copyright to the original author, your license to  use and modify this
 * source is null and void. Use of this software constitutes your agreement
 * to this clause.
 */

include(PATH_THIRD.'reinos_iconfont/config.php');


class Reinos_iconfont_ft extends EE_Fieldtype
{

    public $info = array(
        'name'      => REINOS_ICONFONT_TITLE,
        'version'   => REINOS_ICONFONT_VERSION,
        'has_global_settings' => 'n'
    );

    public $settings = array();

    public $default_settings = array();

    public $has_array_data = TRUE;

    private $prefix;

    // ----------------------------------------------------------------------

    /**
     * Constructor
     *
     * @access public
     *
     * Calls the parent constructor
     */
    public function __construct()
    {
        parent::__construct();

        $this->prefix = REINOS_ICONFONT_MAP.'_';

        //load lang file
        ee()->lang->loadfile(REINOS_ICONFONT_MAP);

        //require settings
        require 'settings.php';
    }

    // ---------------------------------------------------------------------- 
    // Before saving the content to the database
    // ---------------------------------------------------------------------- 

    /**
     * save (Native EE)
     *
     * @access public
     */
    public function save($data)
    {
        return $this->_save($data);
    }

    // ----------------------------------------------------------------------

    /**
     * entry_api_save (Webservcie)
     *
     * @access public
     */
    public function webservice_save($data)
    {
        return $this->_save($data);
    }

    // ----------------------------------------------------------------------

    /**
     * save (Low Variables)
     *
     * @access public
     */
    public function save_var_field($data)
    {
        return $this->_save($data);
    }

    // ---------------------------------------------------------------------- 

    /**
     * save
     *
     * @access public
     */
    private function _save($data = '')
    {
        return $data;
    }

    // ----------------------------------------------------------------------
    // Display the field for all types
    // ----------------------------------------------------------------------

    /**
     * display_field
     *
     * @access public
     */
    function display_field($data)
    {
        return $this->_display_field($data);
    }

    // ----------------------------------------------------------------------

    /**
     * display_var_field (Low variables)
     *
     * @access public
     */
    function display_var_field ($data)
    {
        //generate the data
        return $this->_display_field($data, 'low_variables');
    }

    // ----------------------------------------------------------------------

    /**
     * display_field
     *
     * @access public
     */
    private function _display_field($data)
    {
        //save data
        $data = trim($data);
        $field_name = $this->field_name;

        //just load once
        if ( isset(ee()->session->cache[REINOS_ICONFONT_MAP]['assets_added']) == FALSE)
        {
            $buildVersion = ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->item('debug_mode') === 'y' ? 'development' : 'production';

            ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->mcp_meta_parser('css_custom_path', ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->item('theme_url') . 'dist/iconfont.bundle.css');
            ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->mcp_meta_parser('js_custom_path', ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->item('theme_url') . 'dist/iconfont.' . $buildVersion . '.bundle.js');

            ee()->session->cache[REINOS_ICONFONT_SERVICE_NAME]['assets_added'] = true;
        }

        //js variable how to get the data
        $iconGenerator = '';

        // set the fieldname
        $iconfont_field_name = 'iconfont_field_'.time().uniqid();

        $preset_query = ee('Model')->get(REINOS_ICONFONT_SERVICE_NAME.':Preset')->filter('preset_id', $this->settings[REINOS_ICONFONT_MAP.'_preset']);

        if($preset_query->count() == 0) {
            return 'No preset chosen, please go to your fieldtype and select a preset';
        }

        $preset = $preset_query->first();

        // load the fonts
        if($preset->provider == 'font_awesome')
        {
            ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->mcp_meta_parser('css_custom_path', 'https://pro.fontawesome.com/releases/v5.10.0/css/all.css');
        }
        else if($preset->provider == 'material')
        {
            ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->mcp_meta_parser('css_custom_path', 'https://fonts.googleapis.com/icon?family=Material+Icons');

            $iconGenerator = "iconGenerator: function( icon ) {
                    return '<i class=\"material-icons\">' + icon + '</i>';
                }
            ";
        }
        else if($preset->provider == 'custom')
        {
            $custom_urls = explode('<br />', nl2br($preset->custom_css_url));
            if(!empty($custom_urls)) {
                foreach($custom_urls as $url) {
                    ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->mcp_meta_parser('css_custom_path', $url);
                }
            }
        }

        if(!ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->is_json($preset->json_preset)) {
           return '<span style="color: red;">Oeps, it seems the preset got an invalid JSON input.</span>';
        }

        ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->mcp_meta_parser('js_inline', '
            REINOS_ICONFONT.version = "'.REINOS_ICONFONT_VERSION.'";
            REINOS_ICONFONT.init(".'.$iconfont_field_name.'", "'.$this->content_type().'", {
                source: '.$preset->json_preset.',
                '.$iconGenerator.'
            });
        ');

        //set the vars
        $vars = array(
            'field_name' => $field_name,
            'class' => 'iconfont_'.$this->content_type().' '.$iconfont_field_name,
            'selected' => $data,
            'type' => $this->content_type()
        );

        return ee('View')->make(REINOS_ICONFONT_MAP.':fieldtype')->render($vars);
    }

    // ----------------------------------------------------------------------
    // Replace the tags for all types
    // ----------------------------------------------------------------------

    /**
     * display_var_tag (Low variables)
     *
     * @access public
     */
    public function display_var_tag($var_data, $tagparams, $tagdata)
    {
        return $this->replace_tag($var_data, $tagparams, $tagdata);
    }

    // ----------------------------------------------------------------------

    /**
     * replace_element_tag (Content Elements)
     *
     * @access public
     */
    public function replace_element_tag($data, $params = array(), $tagdata)
    {
        return $this->replace_tag($data, $params, $tagdata);
    }

    // ----------------------------------------------------------------------

    /**
     * replace_tag
     *
     * @access public
     */
    public function replace_tag($data, $params = array(), $tagdata = FALSE)
    {
        $data = trim($data);
        if ($data == FALSE) return;

        return $data;
    }

    // ----------------------------------------------------------------------

    /**
     * replace_tag_catchall
     *
     * @access public
     */
    /*function replace_tag_catchall($file_info, $params = array(), $tagdata = FALSE, $modifier)
    {
    
    }*/

    // ----------------------------------------------------------------------
    // Display the settings for all types
    // ----------------------------------------------------------------------

    /**
     * Display settings screen (Default EE)
     *
     * @access  public
     */
    function display_settings($data)
    {
        $settings_data = $this->_display_settings($data);

        if ($this->content_type() == 'grid')
        {
            ee()->javascript->output("
		
			   var miniGridInit = function(context) {
				   $('.fields-keyvalue', context).miniGrid({grid_min_rows:0,grid_max_rows:''});
			   }
			   Grid.bind('".REINOS_ICONFONT_MAP."', 'displaySettings', function(column) {
				   miniGridInit(column);
				   SelectField.renderFields(column);
				   
			   });
			   FieldManager.on('fieldModalDisplay', function(modal) {
				   miniGridInit(modal);
			   });
			");
            return array('field_options_'.REINOS_ICONFONT_MAP => $settings_data);
        }

        return array(
            'field_options_'.REINOS_ICONFONT_MAP => array(
                'label' => 'field_options',
                'group' => REINOS_ICONFONT_MAP,
                'settings' => $settings_data
            )
        );
    }


    // --------------------------------------------------------------------

    /**
     * Display settings screen (Low variables)
     *
     * @access  public
     */
//    function display_var_settings($data)
//    {
//        return $this->_display_settings($data);
//    }

    // --------------------------------------------------------------------

    /**
     * Display settings screen (EE 2.7 GRID)
     *
     * @access  public
     */
//    function grid_display_settings($data)
//    {
//        $return = $this->_display_settings($data, array(), 'grid');
//
//		ee()->javascript->output("
//		   var miniGridInit = function(context) {
//			   $('.fields-keyvalue', context).miniGrid({grid_min_rows:0,grid_max_rows:''});
//		   }
//		   Grid.bind('select', 'displaySettings', function(column) {
//			   miniGridInit(column);
//			   SelectField.renderFields(column)
//		   });
//		   FieldManager.on('fieldModalDisplay', function(modal) {
//			   miniGridInit(modal);
//		   });
//		");
//
//		return $return;
//
//    }

    // --------------------------------------------------------------------

    /**
     * Display settings screen (Content Elements)
     *
     * @access  public
     */
//    function display_element_settings($data)
//    {
//        return $this->_display_settings($data);
//    }

    // --------------------------------------------------------------------

    /**
     * Display settings screen
     *
     * @access  public
     */
    // --------------------------------------------------------------------

    /**
     * Display settings screen
     *
     * @access  public
     */
    private function _display_settings($data, $type = 'native')
    {
        $return = array();

        if(!empty($this->fieldtype_settings))
        {
            foreach($this->fieldtype_settings as $field=>$options)
            {
                //set the override value
                $override_value = false;
                if(isset($options['override']))
                {
                    $override_value = ee(REINOS_ICONFONT_SERVICE_NAME.':Settings')->get_setting($options['override'].'_override');
                }

                //set some default options value
                $options['def_value'] = isset($options['def_value']) ? $options['def_value'] : '' ;
                $options['global'] = isset($options['global']) ? $options['global'] : '' ;

                //is overrided?
                if($override_value !== false && $override_value !== '')
                {
                    $options['value'] = $override_value;

                }
                //default value
                else
                {
                    $options['value'] = isset($data[$this->prefix.$options['name']]) ? $data[$this->prefix.$options['name']] : $options['def_value'];
                }

                //global?
                if($options['global'])
                    continue;

                //check if we need to load dynamic data
                if(isset($options['choices']) && is_string($options['choices']))
                {
                    $split = explode('|', $options['choices']);
                    $service = str_replace('service:', '', $split[0]);
                    $method = str_replace('method:', '', $split[1]);

                    $options['choices'] = ee(REINOS_ICONFONT_SERVICE_NAME.':'.ucfirst($service))->{$method}($options, $this->prefix);
                }

                if(isset($options['content']) && is_string($options['content']))
                {
                    $split = explode('|', $options['content']);
                    $service = str_replace('service:', '', $split[0]);
                    $method = str_replace('method:', '', $split[1]);

                    $options['content'] = ee(REINOS_ICONFONT_SERVICE_NAME.':'.ucfirst($service))->{$method}($options, $this->prefix);
                }

                if($type == 'native')
                {
                    $return[] = array(
                        'title' => $options['label'],
                        'desc' => isset($options['desc']) ? $options['desc'] : '',
                        'fields' => $this->generateField($options)
                    );
                }

                else if($type == 'low_var')
                {
                    $options['field_name'] = $this->prefix.$options['name'];
                    $options['grid'] = false;
                    $options['field'] = $this->generatePerField($options);
                    $return[] = array(
                        $this->prefix.$options['name'],
                        ee('View')->make('ee:_shared/form/field')->render($options)
                    );
                }
            }
        }

        return $return;
    }

    // ----------------------------------------------------------------------
    // Save the settings for all types
    // ----------------------------------------------------------------------

    /**
     * save_settings (Default EE)
     *
     * @access public
     */
    function save_settings($data)
    {
        $settings = $this->_save_settings($data);

        if(isset($this->field_wide) && $this->field_wide)
        {
            $settings['field_wide'] = $this->field_wide;
        }

        return $settings;
    }

    // --------------------------------------------------------------------

    /**
     * save_settings ((Low variables))
     *
     * @access public
     */
    function save_var_settings($data)
    {
        return $this->_save_settings($data);
    }

    // --------------------------------------------------------------------

    /**
     * save_settings (EE 2.7 GRID)
     *
     * @access public
     */
    function grid_save_settings($data)
    {
        return $this->_save_settings($data, true);
    }

    // --------------------------------------------------------------------

    /**
     * save_settings
     *
     * @access public
     */
    private function _save_settings($data, $use_data = false)
    {
        $return = array();

        if(!empty($this->fieldtype_settings))
        {
            foreach($this->fieldtype_settings as $field=>$options)
            {
                //global?
                if(isset($options['global']) && $options['global'])
                    continue;

                $data[$this->prefix.$options['name']] = isset($data[$this->prefix.$options['name']]) ? $data[$this->prefix.$options['name']] : '';
                $post_value =  $use_data ? $data[$this->prefix.$options['name']] : ee()->input->post($this->prefix.$options['name']);

                //mini grid?
                if(isset($options['mini_grid']) && $options['mini_grid'])
                {
                    $new_data_rows = array();
                    if(!empty($post_value))
                    {
                        foreach($post_value as $rows)
                        {
                            foreach($rows as $row)
                            {
                                $_new_data_rows = array(
                                    'value' => $row['value']
                                );

                                //enable 2 field if needed
                                if(isset($options['mini_grid_show_label']) && $options['mini_grid_show_label'])
                                {
                                    $_new_data_rows['label'] = $row['label'];
                                }

                                $new_data_rows[] = $_new_data_rows;
                            }
                        }
                    }

                    //serialize it so we can save it to the database
                    $post_value = serialize($new_data_rows);
                }

                $return[$this->prefix.$options['name']] = $post_value;
            }
        }

        return $return;
    }

    // ----------------------------------------------------------------------

    /**
     * Validates the field input (EE)
     *
     * @access public
     */
    public function validate($data)
    {
        return $this->_validate($data);
    }

    // ----------------------------------------------------------------------

    /**
     * Validates the field input
     *
     * @access public
     */
    public function _validate($data)
    {
        return true;
    }

    // --------------------------------------------------------------------

    /**
     * Do additional processing after the field is created/modified. (EE)
     *
     * @access public
     */
    public function post_save_settings($data)
    {
        $this->_post_save_settings($data);
    }

    // --------------------------------------------------------------------

    /**
     * Do additional processing after the field is created/modified.
     *
     * @access public
     */
    public function _post_save_settings($data)
    {

    }

    // ----------------------------------------------------------------------

    /**
     * install
     *
     * @access public
     */
    function install()
    {
        $return = array();

        if(!empty($this->fieldtype_settings))
        {
            foreach($this->fieldtype_settings as $field=>$options)
            {
                $return[$this->prefix.$options['name']] = $options['def_value'];
            }
        }

        return $return;
    }

    // ----------------------------------------------------------------------

    /**
     * Update
     */
    function update()
    {
        return TRUE;
    }

    // ----------------------------------------------------------------------

    /**
     * display_global_settings
     *
     * @access public
     */
    function display_global_settings()
    {
        $data = array_merge($this->settings, $_POST);

        $form = '';
        foreach($this->fieldtype_settings as $field=>$options)
        {
            //global?
            if(!$options['global'])
                continue;

            switch($options['type'])
            {
                //multiselect
                case 'm' :
                    $form .= form_label($options['label'], $options['label']).NBS.form_multiselect($this->prefix.$options['name'], $options['options'], (isset($data[$this->prefix.$options['name']]) ? $data[$this->prefix.$options['name']] : $options['def_value'] )).NBS.NBS.NBS.' ';
                    break;

                //select field
                case 's' :
                    $form .= form_label($options['label'], $options['label']).NBS.form_dropdown($this->prefix.$options['name'], $options['options'], (isset($data[$this->prefix.$options['name']]) ? $data[$this->prefix.$options['name']] : $options['def_value'] )).NBS.NBS.NBS.' ';
                    break;

                //text field
                default:
                case 't' :
                    $form .= form_label($options['label'], $options['label']).NBS.form_input($this->prefix.$options['name'], (isset($data[$this->prefix.$options['name']]) ? $data[$this->prefix.$options['name']] : $options['def_value'] )).NBS.NBS.NBS.' ';
                    break;
            }
        }

        return $form;
    }

    // ----------------------------------------------------------------------

    /**
     * save_global_settings
     *
     * @access public
     */
    function save_global_settings()
    {
        return array_merge($this->settings, $_POST);
    }

    // ---------------------------------------------------------------------- 

    /**
     * accepts_content_type (GRID EE 2.7)
     *
     * @access public
     */
    public function accepts_content_type($name)
    {
        return ($name == 'channel' || $name == 'grid' || $name == 'fluid_field' || $name == 'blocks/1');
        //return true;
    }

    // --------------------------------------------------------------------

    /**
     * Generate the settings fields
     * @param array $options
     * @return array
     */
    private function generateField($options = array())
    {
        $return = array(
            $this->prefix.$options['name'] => $this->generatePerField($options)
        );

        return $return;
    }

    // ----------------------------------------------------------------------

    /**
     * Generate per field
     * @param array $options
     * @return array
     */
    private function generatePerField($options = array())
    {
        $field_options = $options;

        if(isset($options['options']))
        {
            $field_options['choices'] = $options['options'];
        }

        //mini grid?
        if(isset($options['mini_grid']) && $options['mini_grid'])
        {
            //is serialized
            if(ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->is_serialized($options['value']))
            {
                $options['value'] = unserialize($options['value']);
            }

            //set the value
            $options['value'] = $options['value'] != '' ? $options['value'] : '';

            //parse the grid
            $grid = $this->getValueLabelMiniGrid($options);

            //show it
            $field_options['content'] = ee('View')->make('ee:_shared/form/mini_grid')->render($grid->viewData());
        }

        unset($field_options['name']);

        return $field_options;
    }

    // ----------------------------------------------------------------------

    /**
     * Creates a mini Grid field based on the data in the 'value_label_pairs' key
     *
     * @return MiniGridInput object
     */
    private function getValueLabelMiniGrid($option)
    {
        $grid = ee('CP/MiniGridInput', array(
            'field_name' => $this->prefix.$option['name']
        ));
        $grid->loadAssets();

        $columns = array('Value');
        if(isset($option['mini_grid_show_label']) && $option['mini_grid_show_label'])
        {
            $columns[] = 'Label';
        }
        $grid->setColumns($columns);

        $grid->setNoResultsText(lang('no_value_label_pairs'), lang('add_new'));

        //enable 2 field if needed
        $blank_row = array(array('html' => form_input('value', '')));
        if(isset($option['mini_grid_show_label']) && $option['mini_grid_show_label'])
        {
            $blank_row[] = array('html' => form_input('label', ''));
        }

        $grid->setBlankRow($blank_row);
        $grid->setData(array());

        if (isset($option['value']) && is_array($option['value']))
        {
            $pairs = array();
            $i = 1;
            foreach ($option['value'] as $row)
            {
                //is the label field enabled?
                $columns = array(array('html' => form_input('value', $row['value'])));
                if(isset($option['mini_grid_show_label']) && $option['mini_grid_show_label'])
                {
                    $columns[] = array('html' => form_input('label', $row['label']));
                }

                $pairs[] = array(
                    'attrs' => array('row_id' => $i),
                    'columns' => $columns
                );
                $i++;
            }

            $grid->setData($pairs);
        }

        return $grid;
    }

    // ----------------------------------------------------------------------

    /**
     * Get field setting
     *
     * @param string $name
     * @return mixed|string
     */
    public function get_setting($name = '', $default = false)
    {
        if(isset($this->settings[$name]))
        {
            return $this->settings[$name];
        }

        return '';
    }


    // ---------------------------------------------------------------------- 
    // Custom 
    // ---------------------------------------------------------------------- 

    /**
     * _set_map_data
     *
     * @access private
     */
    /*private function _set_map_data($data)
    {
        $data = json_decode(base64_decode($data));

        $new_data = array(
            'map' => array(),
            'markers' => array(
                'latlng' => '',
                'icon' => '',
                'title' => ''
            )
        );

        foreach($data as $key=>$val)
        {
            //map data
            if(isset($val->map))
            {
                foreach($val->map as $k=>$v)
                {
                    if(is_array($v))
                    {
                        $new_data['map'][$k] = implode('|', $v);
                    }
                    else
                    {
                        $new_data['map'][$k] = $v;
                    }    
                }
            } 

            if(isset($val->markers))
            {
                foreach($val->markers as $k=>$v)
                {
                    $new_data['markers']['latlng'][] = $v->lat.','.$v->lng;
                    $new_data['markers']['title'][] = $v->title;
                    $new_data['markers']['icon'][] = isset($v->icon) ? $v->icon : null;
                }  

                $new_data['markers']['latlng'] = is_array($new_data['markers']['latlng']) ? implode('|', $new_data['markers']['latlng']) : '';
                $new_data['markers']['title'] = is_array($new_data['markers']['title']) ? implode('|', $new_data['markers']['title']) : '';
                $new_data['markers']['icon'] = is_array($new_data['markers']['icon']) ? implode('|', $new_data['markers']['icon']) : '';
            }
        }

        return $new_data;
    }*/

    // ----------------------------------------------------------------------

    /**
     * _set_params
     *
     * @access private
     */
    /*private function _set_params($params)
    {
        $new_params = '';
        $method = 'geocoding'; //default
        $allowed_methods = array('geocoding', 'polygon', 'polyline'); //allowed

        if(!empty($params))
        {
            foreach($params as $key=>$val)
            {
                if($key == 'method')
                {
                    if(in_array($val, $allowed_methods))
                    {
                        $method = $val;
                    }
                }
                else
                {
                    $new_params .= $key.'="'.$val.'"';
                }
            }
        }

        return array('method' => $method, 'params' => $new_params);
    }*/

    // ----------------------------------------------------------------------

}

