<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * @author		Rein de Vries <support@reinos.nl>
 * @link		https://addons.reinos.nl
 * @copyright 	Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * @license     https://addons.reinos.nl/commercial-license
 *
 * Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * All rights reserved.
 *
 * This source is commercial software. Use of this software requires a
 * site license for each domain it is used on. Use of this software or any
 * of its source code without express written permission in the form of
 * a purchased commercial or other license is prohibited.
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 *
 * As part of the license agreement for this software, all modifications
 * to this source must be submitted to the original author for review and
 * possible inclusion in future releases. No compensation will be provided
 * for patches, although where possible we will attribute each contribution
 * in file revision notes. Submitting such modifications constitutes
 * assignment of copyright to the original author (Rein de Vries and
 * Reinos.nl Internet Media) for such modifications. If you do not wish to assign
 * copyright to the original author, your license to  use and modify this
 * source is null and void. Use of this software constitutes your agreement
 * to this clause.
 */

require_once(PATH_THIRD.'reinos_iconfont/config.php');

class Reinos_iconfont_ACT
{
	/**
	 * Constructor
	 *
	 */
	function __construct()
	{
		ee()->lang->loadfile(REINOS_ICONFONT_MAP);

		//require the settings and the actions
		require PATH_THIRD.REINOS_ICONFONT_MAP.'/settings.php';
	}

	// ----------------------------------------------------------------------------------

	/**
	 * dispatch the actions via ajax or so.
	 */
	function init ()
	{
		//get the method
		$method = ee()->input->get_post('method');

		//build the class name
		$class = '\\Reinos\\'.REINOS_ICONFONT_NAMESPACE_CLASS.'\\Core\\Action\\' . ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->studlyCase($method);

		//class not exists
		if (class_exists($class) === false) {
			echo 'no_method';
			exit;
		}

		//init the class
		$action = new $class();

		//return it when calling the parse function
		echo $action->execute();
		exit;
	}
}
