<?php

/**
 * @author		Rein de Vries <support@reinos.nl>
 * @link		https://addons.reinos.nl
 * @copyright 	Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * @license     https://addons.reinos.nl/commercial-license
 *
 * Copyright (c) 2011 - 2021 Reinos.nl Internet Media
 * All rights reserved.
 *
 * This source is commercial software. Use of this software requires a
 * site license for each domain it is used on. Use of this software or any
 * of its source code without express written permission in the form of
 * a purchased commercial or other license is prohibited.
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 *
 * As part of the license agreement for this software, all modifications
 * to this source must be submitted to the original author for review and
 * possible inclusion in future releases. No compensation will be provided
 * for patches, although where possible we will attribute each contribution
 * in file revision notes. Submitting such modifications constitutes
 * assignment of copyright to the original author (Rein de Vries and
 * Reinos.nl Internet Media) for such modifications. If you do not wish to assign
 * copyright to the original author, your license to  use and modify this
 * source is null and void. Use of this software constitutes your agreement
 * to this clause.
 */

namespace Reinos\Iconfont\Service;

require_once PATH_THIRD.'reinos_iconfont/config.php';

class Provider {

	public $providers = [
	    'font_awesome' => [
	        'name' => 'Font Awesome',
            'jsonUrl' => '/themes/user/reinos_iconfont/assets/json/font_awesome.json',
        ],
        'material' => [
            'name' => 'Material',
            'jsonUrl' => '/themes/user/reinos_iconfont/assets/json/material.json',
        ]
    ];

    public function getJson($provider) {
        if(isset($this->providers[$provider])) {
            return $this->fetchJson($this->providers[$provider]['jsonUrl']);
        }

        return false;
    }

    private function fetchJson($url) {
        $url = strpos('http://', $url) === false ? ee(REINOS_ICONFONT_SERVICE_NAME.':Helper')->remove_double_slashes(ee()->config->item('site_url').$url) : $url;
        $data = file_get_contents($url);

        if($data !== false && $data != '')
        {
            return $data;
        }

        return false;
    }
    /**
     * Fetch a provider list based on the name
     *
     * @param $providerName
     * @return false|string
     */
    public function fetch($providerName) {
        switch ($providerName) {
            case 'font_awesome':
                return $this->fetchFontAwesome();

            case 'material':
                return $this->fetchMaterial();
        }
    }

    /**
     * Fetch all icons from the FontAwesome list
     *
     * @return false|string
     */
    public function fetchFontAwesome() {
        $icons = json_decode(file_get_contents('https://raw.githubusercontent.com/FortAwesome/Font-Awesome/master/metadata/icons.json'));
        $iconPrefix = "fa-";
        $styleMap = [
            'brands' => "fab",
            'regular' => "far",
            'solid' => "fas"
        ];
        $parsedIcons = [];

        foreach($icons as $iconName => $icon) {
            foreach($icon->styles as $style) {
                $styleName = $styleMap[$style];

                if(!isset($parsedIcons[$style])) {
                    $parsedIcons[$style] = [];
                }

                $parsedIcons[$style][] = $styleName . ' ' . $iconPrefix . '' .$iconName;
            }
        }

        return json_encode($parsedIcons, JSON_PRETTY_PRINT);
    }

    /**
     * Fetch all icons from Material
     *
     * @return false|string
     */
    public function fetchMaterial() {
        $material = json_decode(file_get_contents('https://material.io/resources/icons/static/data.json'));

        $icons = new \stdClass;
        foreach($material->categories as $key => $category) {
            $icons->{$category->name} = [];

            foreach ($category->icons as $icon) {
                $icons->{$category->name}[] = $icon->id;
            }
        }
        return json_encode($icons, JSON_PRETTY_PRINT);
    }
}
