<?php
/**
 * Redirect Pro
 *
 * @package     ExpressionEngine
 * @subpackage  Addons
 * @category    Module
 * @author      Imam Husayn
 * @link        
 */

include_once 'addon.setup.php';

Class Redirect_pro_upd {

	public function install(){
		
		//create the redirect setting table		
		ee()->load->dbforge();

        $fields = array(
            'redirect_id'                   => array('type' => 'int(10)', 'unsigned' => true, 'auto_increment' => true),
            'redirect_from'			=> array('type' => 'text', 'null' => false),
            'redirect_to'       	=> array('type' => 'text', 'null' => false),
            'start_date'          	=> array('type' => 'date', 'null' => true),
            'end_date' 				=> array('type' => 'date', 'null' => true),
            'count' 				=> array('type' => 'int(20)', 'null' => false, 'default' => '0'),
            'site_id'              	=> array('type' => 'int(11)', 'null' => false, 'default' => '0'),
        );

        ee()->dbforge->add_field($fields);
        ee()->dbforge->add_key('redirect_id', true);
        ee()->dbforge->add_key('site_id');
        ee()->dbforge->create_table('redirects');

        //add module entry
		$data = array(
		   'module_name' 		=> IHRP_MODULE_NAME,
		   'module_version' 	=> IHRP_VERSION,
		   'has_cp_backend' 	=> 'y',
		   'has_publish_fields' => 'n'
		);

		ee()->db->insert('modules', $data);

		return true;

	}

	public function update($current = '')
	{
		return true;
	}

	public function uninstall(){

		//delete redirects table
        ee()->load->dbforge();
        ee()->dbforge->drop_table('redirects');

        //delete module entry
		ee()->db->where('module_name', IHRP_MODULE_NAME);
        ee()->db->delete('modules');

        //delete the extension
        ee()->db->where('class', 'Redirect_pro_ext');
        ee()->db->delete('extensions');

        return true;

	}

}