<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 * JCOGS Image English Language file
 * =================================
 *
 * @category   ExpressionEngine Add-on
 * @package    JCOGS Image
 * @author     JCOGS Design <contact@jcogs.net>
 * @copyright  Copyright (c) 2021 - 2023 JCOGS Design
 * @license    https://jcogs.net/add-ons/jcogs_img/license.html
 * @version    1.3.21.1
 * @link       https://JCOGS.net/
 * @since      File available since Release 1.0.0
 */

$lang = [
    'jcogs_img_module_name'                                 => JCOGS_IMG_NAME,
    'jcogs_img_module_description'                          => 'Adds Image manipulation facilities to the EE CMS.',
    'jcogs_img_settings'                                    => 'Settings',
    'jcogs_img_nav_title'                                   => 'Options',
    'jcogs_img_version'                                     => 'JCOGS Image Version: %s',
    'jcogs_img_debug_info'                                  => 'Debug Information',
    'jcogs_img_debug_php_version'                           => 'php Version: %s',
    'jcogs_img_debug_ee_version'                            => 'EE Version: %s',
    'jcogs_img_debug_async_support'                         => 'Async support: %s',
    'nav_support_page'                                      => 'Documentation & Support',

    // Main settings page strings         
    'jcogs_img_cp_main_settings'                            => 'System Settings',
    'jcogs_img_cp_system_enable'                            => 'On/Off control',
    'jcogs_img_cp_enable_globally'                          => 'Enable JCOGS Image',
    'jcogs_img_cp_enable_globally_desc'                     => 'Use this to turn JCOGS Image processing on or off',
    'jcogs_img_cp_class_always_output_full_urls'            => 'Use full URLs in paths to processed images',
    'jcogs_img_cp_class_always_output_full_urls_desc'       => 'JCOGS Image normally generates HTML tags with <span style="font-weight:bold">relative paths</span> to processed images.<br>This gives the best performance on most systems.<br>On some server systems there may be problems resolving relative paths to processed images. Where this occurs this option allows you to instruct JCOGS Image to always use full URLs to reference the processed images.<br><br><span style="font-weight:bold">Note:</span> If you choose this option you will not be able to set a processed image prefix to a CDN or similar (since you have told Image to use the local server URL instead).',
    'jcogs_img_cp_path_prefix'                              => 'Specify a default image path prefix (e.g. to an image CDN server / service)',
    'jcogs_img_cp_path_prefix_desc'                         => 'Enter a default prefix for the published path to a processed image.<br><span style="font-weight:bold">Note:</span> The prefix will only be added to a JCOGS Image tag that has the parameter <span style="color:var(--ee-success-dark);font-weight:bold">use_image_path_prefix=\'yes\'</span> set, otherwise this value is ignored.<br>The value can be overridden within a tag by setting the parameter <span style="color:var(--ee-success-dark);font-weight:bold">image_path_prefix=</span>. The default value for this setting is blank.',
    'jcogs_img_cp_ee_version_invalid'                       => 'The EE version reported by your server is invalid',
    'jcogs_img_cp_ee_version_invalid_desc'                  => 'JCOGS Image requires EE 5.4 or better to operate, your server is reporting EE version %1$s.<br>JCOGS Image will not operate with earlier versions.',
    'jcogs_img_cp_php_version_invalid'                      => 'The php version reported by your server is invalid',
    'jcogs_img_cp_php_version_invalid_desc'                 => 'JCOGS Image requires php 7.4 or better to operate, your server is reporting php version %1$s.<br>JCOGS Image will not operate with earlier versions.',
    'jcogs_img_cp_invalid_license'                          => 'JCOGS Image requires a valid license to operate on public domains.',
    'jcogs_img_system_options'                              => 'Default Add-On Settings',
    'jcogs_img_system_options_storage'                      => 'Image Path options',
    'jcogs_img_system_options_debug'                        => 'Debugging options',
    
    // Caching settings page strings         
    'jcogs_img_caching_page_title'                          => 'Image Cache: Controls + Settings',
    'jcogs_img_caching_sidebar_label'                       => 'Image Cache',
    'jcogs_img_cp_cache_status'                             => 'Image Cache Status',
    'jcogs_img_cp_cache_controls'                           => 'Image Cache Controls',
    'jcogs_img_cp_cache_settings'                           => 'Image Cache Settings',
    'jcogs_img_cp_cache_performance_desc_no_cache'          => '<div  style="font-size:15px;padding-top:0.4rem;padding-bottom:0.4rem;"><span class=\'status-tag st-warning\'>CACHE EMPTY</span></div>',
    'jcogs_img_cp_cache_performance_desc_cache'             => '<div  style="font-size:15px;padding-top:0.4rem;padding-bottom:0.4rem;"><span class=\'status-tag st-open\'>CACHE OPERATIONAL</span></div><ul><li>There are %1$d processed images in %2$s.</li><li>%3$d images with total file size of %4$s have been served from by the JCOGS Image caching system since it was last reset %5$s ago, saving %6$0.2f seconds of server processing time.</li></ul>',
    'jcogs_img_cp_cache_performance_desc_cache_single'      => 'the JCOGS Image cache folder',
    'jcogs_img_cp_cache_performance_desc_cache_many'        => '%1$d JCOGS Image cache folders',
    'jcogs_img_cp_default_cache_duration'                   => '<label style=\'font-size:15px;\'>Caching: Default duration for cached images (in seconds).</label>',
    'jcogs_img_cp_default_cache_duration_desc'              => 'The default value is the equivalent of one month (31 days - so 31 x 24 x 60 x 60): a value which maximises cache operation while still allowing JCOGS Image\'s cache audit process to keep the cache tidy.  Set the value to -1 to have a default of a perpetual cache (i.e. cached images are never removed - similar to the caching model used in CE-Image). Set the value to 0 to have a default where the cache is disabled. <br>Can be overridden by the <span style="color:var(--ee-success-dark);font-weight:bold">cache=</span> parameter within a tag.',
    'jcogs_img_cp_default_cache_duration_minus_one_option'  => 'A default value is required.',
    'jcogs_img_cp_cache_clear'                              => 'Clear the Image Cache',
    'jcogs_img_cp_cache_clear_desc'                         => '<p>Clearing the JCOGS Image cache will remove all processed images from the cache. This action will save server disk space and will require JCOGS Image to reprocess each image when it is requested by your site template tags; this need for additional image processing may temporarily affect site performance.</p><p>Use this button to clear the %1d images in the JCOGS Image cache and reset the statistics held on cache usage.</p>',
    'jcogs_img_cp_cache_clear_desc_empty'                    => '<p>Clearing the JCOGS Image cache will remove all processed images from the cache. This action will save server disk space and will require JCOGS Image to reprocess each image when it is requested by your site template tags; this need for additional image processing may temporarily affect site performance.</p><p>When the cache has something in it, you can use this button to clear it and reset the statistics held on cache usage.</p>',
    'jcogs_img_cp_cache_clear_button'                       => '<a class="button button--primary" rel="" href="%1$s" %2$s>Clear the JCOGS Image Cache</a>',
    'jcogs_img_cp_cache_cleared'                            => 'Image Cache Cleared',
    'jcogs_img_cp_cache_cleared_desc'                       => '%1d images have been cleared from the JCOGS Image cache and the statistics on cache usage have been reset.',
    'jcogs_img_cp_enable_cache_auto_manage'                 => 'Enable Cache Auto-Management',
    'jcogs_img_cp_enable_cache_auto_manage_desc'            => 'When <a href="https://jcogs.net/documentation/jcogs_img/jcogs_img-advanced-topics" target="_blank">Image Cache Auto-Management</a> is enabled, JCOGS Image will monitor the <a href="https://docs.expressionengine.com/latest/control-panel/file-manager/file-manager.html" target="_blank">File Manager</a> system; when an image that has been used to generate one or more images in the JCOGS Image cache is modified, those processed images will be cleared from the cache. This is to ensure that any changes made to the source image are reflected on the site. <blockquote><strong>Note:</strong> If you are using <a href="https://docs.expressionengine.com/latest/optimization/caching.html#template-caching" target="_blank">EE Template Caching</a> or a static caching system, <strong>enabling this feature is not recommended.</strong></blockquote>',
    'jcogs_img_cp_enable_cache_audit'                       => 'Enable Image Cache Audits',
    'jcogs_img_cp_enable_cache_audit_desc'                  => 'When <a href="https://jcogs.net/documentation/jcogs_img/jcogs_img-advanced-topics" target="_blank">Image Cache Audit</a> is enabled, JCOGS Image will periodically inspect the default image cache folder (and from any other image cache folders specified via use of the <span style="color:var(--ee-success-dark);font-weight:bold">cache_dir=</span> parameter within JCOGS Image tags) for any images that have existed for longer than the cache duration in force when they were saved, and remove them.',
    'jcogs_img_cp_default_cache_audit_after'                => 'Set the interval between image cache audits.',
    'jcogs_img_cp_default_cache_audit_after_desc'           => 'This is the time to leave between cache maintenance activities - choose an integer number of seconds. Default value is one week - 60*60*24*7 = 604800 seconds.',
    'jcogs_img_cp_cache_audit_now'                          => 'Run an Image Cache Audit now',
    'jcogs_img_cp_cache_audit_now_since_days'               => '<p>The next <a href="https://jcogs.net/documentation/jcogs_img/jcogs_img-advanced-topics" target="_blank">Image Cache Audit</a> is due to run in %1s days.</p>',
    'jcogs_img_cp_cache_audit_now_since_today'               => '<p>The next <a href="https://jcogs.net/documentation/jcogs_img/jcogs_img-advanced-topics" target="_blank">Image Cache Audit</a> is due to run later today.</p>',
    'jcogs_img_cp_cache_audit_now_desc'                     => '<p>Running a cache audit will remove from the cache any images that have existed there for longer than the cache duration set for them when they were saved. This action will save server disk space but will not otherwise affect Image\'s operations.</p><p>Use this button to trigger a cache audit now.</p>',
    'jcogs_img_cp_cache_audit_now_desc_empty'               => '<p>Running a cache audit will remove from the cache any images that have existed there for longer than the cache duration set for them when they were saved. This action will save server disk space but will not otherwise affect Image\'s operations.</p><p>When there is something in the cache, you can use this button to trigger a cache audit.</p>',
    'jcogs_img_cp_cache_audit_now_button'                   => '<a class="button button--primary" rel="" href="%1s" %2s>Run an Image Cache Audit now</a>',
    'jcogs_img_cp_cache_audit_now_completed'                => 'Image Cache Audit completed.',
    'jcogs_img_cp_cache_audit_now_completed_desc'           => 'The Image Cache Audit has been completed. %2$d images were removed from %1$d cache locations.',
    'jcogs_img_cp_cache_audit_failed'                       => 'Image Cache Audit failed.',
    'jcogs_img_cp_cache_audit_failed_desc'                  => 'The Image Cache Audit failed to complete successfully. This should not happen! Please contact <a href="mailto:support@jcogs.net">JCOGS Image support</a> with the news and to get help resolving the issue.',
    'jcogs_img_cp_cache_path_not_OK'                        => 'Image Cache Audit failed.',
    'jcogs_img_cp_cache_path_not_OK_desc'                   => 'The Image Cache Audit failed because your cache path is not valid.',
    'jcogs_img_image_cache_is_empty'                        => 'Cache is empty',
    'jcogs_img_cp_default_cache_directory'                  => 'Default Cache Directory',
    'jcogs_img_cp_default_cache_directory_desc'             => 'The directory JCOGS Image will use to store processed images. Can be overridden by the <span style="color:var(--ee-success-dark);font-weight:bold">cache_dir=</span> parameter within a tag.<br> <strong>Note:</strong> Since the image cache path needs to be one that is within your site\'s webroot JCOGS Image assumes that the a path entered here is <strong>relative to your webroot</strong>. <br>If the path you specify does not exist JCOGS Image will attempt to create it.<br>To minimise potential problems with JCOGS Image (and other add-ons) please also ensure that your <strong><a href=\'/cp/settings/urls\' target=\'_blank\'>EE \'default base path\'</a></strong> is set correctly.',
    'jcogs_img_cp_default_cache_directory_placeholder'      => 'There needs to be a default directory specified.',
    'jcogs_img_cp_invalid_url_path'                         => 'The path you entered is invalid. The path to the cache directory must be one that would work when included in a public URL (so no spaces, punctuation, wierd characters etc...).',
    'jcogs_img_cp_allow_url_fopen_disabled'                 => 'Some remote file operations disabled',
    'jcogs_img_cp_allow_url_fopen_disabled_desc'            => 'This server appears to have the php directive `allow_url_fopen` disabled.<br>This limitation prevents JCOGS Image from validating its license key, and prevent the add-on working with remote images.<br>Please contact system administrators for your server to resolve this issue. ',
    'jcogs_img_cp_cache_path_invalid'                       => 'Local path to Default Cache Directory is Invalid',
    'jcogs_img_cp_cache_path_invalid_desc'                  => 'JCOGS Image is unable to validate the location given for <b>Default Cache Directory</b>: this is where JCOGS Image saves processed images - without a valid path to this location the add-on is unable to operate.<br>The most likely cause of this issue is that your EE <b>Default base path</b> setting is blank or invalid.',
    'jcogs_img_cp_enable_debugging'                         => 'Enable Debugging Messages in Template Log.',
    'jcogs_img_cp_enable_debugging_desc'                    => 'When enabled, helpful messages are placed in the template debug log as JCOGS Image processes images.',

    // Image settings page strings         
    'img_image_settings'                                    => 'Image Settings',
    'jcogs_img_image_options'                               => 'Default Image Processing Settings',
    'jcogs_img_image_options_format_section'                => 'Image Format Options',
    'jcogs_img_image_operational_defaults'                  => 'Image Operational Defaults',
    'jcogs_img_system_options_limits'                       => 'Operational Limits',
    'img_cp_default_image_format'                           => 'Default image format.',
    'img_cp_default_image_format_desc'                      => 'Choose the default image format to use for processed images.<br> Can be overridden by using the <span style="color:var(--ee-success-dark);font-weight:bold">save_type=</span> parameter within a tag.<br> Choosing <strong>Source</strong> tells JCOGS Image to try and use source image format for output format.<br> The image formats listed are those that your server is able to write/create.<br> <strong>Note: Not all image formats can be rendered by browsers.</strong> If you choose a format that a browser visiting your site cannot render, JCOGS Image will, for that visitor only, substitute an image format that their browser can <strong>can</strong> work with - usually JPG.',
    'img_cp_jpg_default_quality'                            => 'Default image quality.',
    'img_cp_jpg_default_quality_desc'                       => 'Some image formats (e.g. aiff, jpg, webp) have optional quality levels that allow a trade-off between image file-size and image quality; <b>higher</b> quality values equate to larger files but better looking images. The default value (90) is good for most purposes. For AIFF and Webp images, setting the quality value to 100 will result in lossless compression of the image on servers running php 8.1 or better (biggest file-size, best quality image). <br>The value can be overridden by using the <span style="color:var(--ee-success-dark);font-weight:bold">quality=</span> parameter within a tag.',
    'img_cp_jpg_default_quality_required'                   => 'This value cannot be set to a negative or zero value.',
    'img_cp_png_default_quality'                            => 'Default image quality for PNG images.',
    'img_cp_png_default_quality_desc'                       => 'Set the default image quality level for PNG images. The quality level allows a trade-off between image file-size and image quality; for PNG images a <b>lower</b> value equates to a larger file-size but better looking image. The default value (6) is good for most purposes. Setting the quality value to 0 will result in lossless compression (biggest file-size, best image quality). <br>The value can be overridden by using the <span style="color:var(--ee-success-dark);font-weight:bold">png_quality=</span> parameter within a tag.',
    'img_cp_jpg_default_png_quality_required'                   => 'This value cannot be set to a negative or zero value.',
    'img_cp_default_bg_color'                               => 'Default background colour.',
    'img_cp_default_bg_color_desc'                          => 'Sets the colour to use to fill in background of image should an image operation expose some of the background.  Can be overridden by using the <span style="color:var(--ee-success-dark);font-weight:bold">bg_color=</span> parameter within a tag.',
    'jcogs_img_cp_enable_svg_passthrough'                   => 'Enable SVG Passthrough parameter default setting',
    'jcogs_img_cp_enable_svg_passthrough_desc'              => 'When enabled JCOGS Image will automatically pass any SVG format image through to the output without processing it: if specified,  caching and size adjustment changes will be applied to the image. This option can be over-ridden by use of the  <span style="color:var(--ee-success-dark);font-weight:bold">svg_passthrough=</span> parameter within a tag.',
    'jcogs_img_cp_ignore_save_type_for_animated_gifs'       => 'Enable dominance for preserving animated gif image formats',
    'jcogs_img_cp_ignore_save_type_for_animated_gifs_desc'  => 'When enabled JCOGS Image will ignore <span style="color:var(--ee-success-dark);font-weight:bold">save_type=</span> settings when processing an image source file containing an animated gif.',
    'jcogs_img_cp_default_img_width'                        => 'Set default width for unsized images',
    'jcogs_img_cp_default_img_width_desc'                   => 'Operations within JCOGS Image sometimes need to know the width of the original image: for example when Image replaces a missing image with a colour field, or when the image is an SVG. Not all SVG image files contain this information. Some do, others just an aspect ratio (but no base width) and some no information at all. If the SVG contains width information that value will be used to set the original width value for the image, otherwise this value will be used as the default width (in px). This option can be over-ridden by use of the  <span style="color:var(--ee-success-dark);font-weight:bold">default_img_width=</span> parameter within a tag.',
    'jcogs_img_cp_default_img_height'                       => 'Set default height for unsized images',
    'jcogs_img_cp_default_img_height_desc'                  => 'Operations within JCOGS Image sometimes need to know the width of the original image: for example when Image replaces a missing image with a colour field, or when the image is an SVG. Not all SVG image files contain this information. Some do, others just an aspect ratio (but no base width) and some no information at all. If the SVG contains height information that value will be used to set the original width value for the image, otherwise this value will be used as the default height (in px). This option can be over-ridden by use of the  <span style="color:var(--ee-success-dark);font-weight:bold">default_img_height=</span> parameter within a tag.',
    'jcogs_img_cp_allow_scale_larger_default'               => 'Allow Scale Larger parameter default setting',
    'jcogs_img_cp_allow_scale_larger_default_desc'          => 'When the <a href="https://jcogs.net/documentation/jcogs_img/jcogs_img-parameters#jcogs-image-allow-scale-larger" target="_blank">Allow Scale Larger</a> default is set to enabled JCOGS Image will enlarge images to fit dimensions given if the source image is smaller than the final dimensions required by the settings in a JCOGS Image tag. The initial default settings for this option is disabled. This setting is over-ridden by the value given by a <span style="color:var(--ee-success-dark);font-weight:bold">allow_scale_larger=</span> parameter within a tag.',
    'jcogs_img_cp_enable_auto_sharpen'                      => 'Auto Sharpening parameter default setting',
    'jcogs_img_cp_enable_auto_sharpen_desc'                 => 'When the <a href="https://jcogs.net/documentation/jcogs_img/jcogs_img-parameters#jcogs-image-auto-sharpen" target="_blank">Auto Sharpening</a> default is set to enabled JCOGS Image will automatically apply the auto-sharpen filter to every image. The auto-sharpen filter increases the sharpness of images that have been reduced in size during manipulations; the greater the reduction in size the greater the degree of sharpening applied. This option can be over-ridden by use of the  <span style="color:var(--ee-success-dark);font-weight:bold">auto_sharpen=</span> parameter within a tag.',
    'jcogs_img_cp_enable_lazy_loading'                      => 'Lazy parameter default setting',
    'jcogs_img_cp_enable_lazy_loading_desc'                 => 'When the <a href="https://jcogs.net/documentation/jcogs_img/jcogs_img-parameters#jcogs-image-lazy" target="_blank">Lazy</a> parameter default is set to enabled JCOGS Image will set the <strong><img></strong> tags it creates to lazy-load by default.  Can be overridden by using the <span style="color:var(--ee-success-dark);font-weight:bold">lazy=</span> parameter within a tag.',
    'jcogs_img_cp_lazy_loading_mode'                        => 'Choose default lazy loading mode.',
    'jcogs_img_cp_lazy_loading_mode_desc'                   => 'When lazy-loading is enabled JCOGS Image will initially load an image tag with a smaller placeholder image prior to its the "lazy" replacement by the full-quality image. Placeholder images can be either a <strong>Low Quality Image Placeholder (LQIP)</strong> or a <strong>Dominant Colour Field</strong>.<ul><li>LQIP is a low-resolution but recognisable version of the processed image that is typically about 25% of the size of the processed image.</li><li>Dominant Colour Field replaces the image with a colour-field the same size as the processed image with the colour set to the most-common colour found in the processed image.</li><li>A third option - HTML5 - is offered that does not add the placeholder substitution but does add the HTML5 <strong>loading="lazy"</strong> parameter to the completed image tag. This option gives marginally better performance compared to disabling lazy loading on modern browsers where you cannot be sure that javascript will be enabled on the target browser.</ul>',
    'jcogs_img_cp_lazy_progressive_enhancement'             => 'Enable progressive enhancement mode.',
    'jcogs_img_cp_lazy_progressive_enhancement_desc'        => 'When either LQIP or Dominant Colour modes are chosen for Lazy Loading, this option adds some additional code to the rendered template to ensure that the images generated will render correctly in browsers where javascript support is not present or not enabled (<a href="https://gds.blog.gov.uk/2013/10/21/how-many-people-are-missing-out-on-javascript-enhancement/" target="_blank">fewer than 1% of web users</a>). <strong>It is strongly recommended that you leave this option enabled.</strong> Disabling this option will speed the loading of pages slightly, but will also result in users with javascript disabled seeing degraded images; if absolute speed in modern browsers is important, a better solution would be to select the HTML5 option in the Lazy Loading Mode selector above. <br>This option has no effect if HTML5 mode is chosen, or Lazy Loading is disabled.',
    'jcogs_img_cp_lazy_loading_mode_lqip'                   => 'Low Quality Image Placeholder',
    'jcogs_img_cp_lazy_loading_mode_dominant_color'         => 'Dominant Colour Field',
    'jcogs_img_cp_lazy_loading_mode_html5'                  => 'Add HTML5 loading="lazy" only',
    'img_cp_default_bg_color_required'                      => 'This value is required.',
    'jcogs_img_cp_enable_default_fallback_image'            => 'Set a default fallback image',
    'jcogs_img_cp_enable_default_fallback_image_desc'       => 'Set a default image (or colour field) to use to render tags where you fail to specify a src or fallback_src or when sources specified do not map to valid picture files.<br>Choose one of: <ul><li>filling the image space with a colour field</li><li>using a local image</li><li>using a remote image</li></ul>',
    'jcogs_img_cp_no_fallback_image_option'                 => 'No default fallback image',
    'jcogs_img_cp_local_fallback_colour_option'             => 'Use a colour field',
    'jcogs_img_cp_local_fallback_image_option'              => 'Use a local fallback image',
    'jcogs_img_cp_remote_fallback_image_option'             => 'Use a remote fallback image',
    'jcogs_img_cp_fallback_image_colour'                    => 'Colour for fallback colour field',
    'jcogs_img_cp_fallback_image_colour_desc'               => 'Colour to use to fill image space when no src or fallback_src specified (or available).',
    'jcogs_img_cp_fallback_image_local'                     => 'Default fallback image',
    'jcogs_img_cp_fallback_image_local_desc'                => 'Choose a local image to use as a fallback source wnen no src or fallback_src are specified (or available).',
    'jcogs_img_cp_fallback_image_remote'                    => 'Default fallback image',
    'jcogs_img_cp_fallback_image_remote_desc'               => 'Choose a remote image to use as a fallback source wnen no src or fallback_src are specified (or available).',
    'jcogs_img_cp_enable_auto_adjust'                       => 'Enable Auto-adjust for Oversized Source Images',
    'jcogs_img_cp_enable_auto_adjust_desc'                  => 'If selected this enables JCOGS Image\'s ability to attempt to auto-adjust the file size and dimensions of <strong>oversized source images</strong>.<br><strong>Note:</strong> A source image is considered to be oversized if it exceeds either your choice for the a maximum dimension for the source image or your choice for the maximum file size for the source image.<br>While this option is enabled JCOGS Image will try to rescale source images that exceed either of the set limits and so create a smaller interim version of the image file that is compliant with the limits which will then be used as the base for any image transformations requested.<br>Using the smaller interim version may improve overall processing speed and mitigate problems that would otherwise be caused by hitting php resource limits on your server.<br>Images are tested first against the image dimension limit (if set) and then against the size limit.<br> <strong>Note:</strong> if this options is disabled, the constraint on maximum file size will still be applied, but rather than triggering an attempt to rescale the image, the limit will cause Image to not attempt to process the image.',
    'jcogs_img_cp_default_max_image_dimension'              => 'Maximum dimension limit for source image processing (px)',
    'jcogs_img_cp_default_max_image_dimension_desc'         => 'Set a maximum dimension for <strong>source</strong> image files.<br>JCOGS Image will attempt to temporarily rescale any source file that is larger than the set limit in either dimension such that its maximum dimension equals the limit value (the image aspect ratio is preserved).<br>Setting this limit can help to mitigate problems caused by php resource limits on your server.<br>The limit is expressed as an integer pixel value: to enter a value use an integer value (e.g. 2500).<br>To disable this option set this value to zero (which is the default value).',
    'jcogs_img_cp_default_max_image_size'                   => 'Maximum source image size (MB)',
    'jcogs_img_cp_default_max_image_size_desc'              => 'Set a maximum filesize for <strong>source</strong> image files.<br> If <strong>Auto-adjust for Oversized Source Images</strong> is enabled, JCOGS Image will attempt to temporarily rescale any source image with a filesize larger than the set limit to one with a filesize smaller than the limit. Otherwise if a source file has a filesize larger than the limit set it will not be processed.<br>Enter an integer value equal to the maximum size in Mbytes an image file may be (e.g. 4 - the default value).',

    // Advanced Settings Page strings
    'jcogs_img_advanced_settings'                           => 'Advanced Settings',
    'jcogs_img_advanced_settings_heading'                   => 'Defaults for JCOGS Image Advanced Settings',
    'jcogs_img_cp_advanced_options'                         => 'View Advanced Options',
    'jcogs_img_cp_advanced_options_desc'                    => 'Use this to view some Advanced Options for JCOGS Image processing: be careful how you change these values - in most cases the default values are sufficient for stable / safe use of this add-on.',
    'jcogs_img_cp_enable_browser_check'                     => 'Enable active checking of browser capabilities',
    'jcogs_img_cp_enable_browser_check_desc'                => 'When enabled JCOGS Image will actively check the image rendering capabilities of the browser visiting your EE site; if the browser is not able to render the image format you have selected (either via the <code>save_type=</code> parameter, or via the default option for processed image file format) it will change the format of the processed image to be one that the browser can render; if the target image format is one that enables transparency the fallback format will be PNG, otherwise it will be JPG.',
    'jcogs_img_cp_class_consolidation_default'              => 'Enable class / style attribute consolidation for tag-pair operation',
    'jcogs_img_cp_class_consolidation_default_desc'         => 'When enabled JCOGS Image will separately find and consolidate the contents of all of the class=\'\' and style=\'\' parameters if finds enclosed within a JCOGS Image tag-pair, along with the content of any style=\'\' or class=\'\' parameter specfied within the opening JCOGS Image tag, to ensure that there is at most a single composite class and / or style statement in the final tag produced. JCOGS Image will also remove any class duplicates. By default this function is enabled. You may want to disable the function if you plan to enclose complex HTML structures with multiple class statements within a JCOGS Image tag pair or nest multiple tags with differing class statements for each.',
    'jcogs_img_cp_attribute_variable_expansion_default'     => 'Enable expansion of Image Variables within attribute parameter text',
    'jcogs_img_cp_attribute_variable_expansion_default_desc'=> 'When enabled JCOGS Image will expand any Image Variables found within the content of the <span style="color:var(--ee-success-dark);font-weight:bold">attribute=</span> parameter before the output tag is assembled.',
    'jcogs_img_cp_default_filename_separator'               => 'Cache filename separator character(s)',
    'jcogs_img_cp_default_filename_separator_desc'          => 'The filenames used for processed images have three components (original filename, cache duration marker, image processing options marker). To be able to separate out these three elements the filename needs to include a couple of separator markers.<br>If the filename separator used is also used in the filenames of the images you are processing some problems may arise relating to the retrieval of cached images.<br>To avoid such naming conflicts you can change the separator used here.<br>The separator can be any sequence of characters, but it cannot include <strong>spaces</strong> or any <strong>reserved characters</strong>: <code> !*\'();:@&=+$,/?#[])</code>',
    'jcogs_img_cp_invalid_separator_string'                 => 'Please make sure that your separator string has at least one character and does not contain spaces or reserved characters.',
    'jcogs_img_cp_default_max_source_filename_length'       => 'Limit the maximum length of the reflected copy of source filename',
    'jcogs_img_cp_default_max_source_filename_length_desc'  => 'Some servers have a limit on the length of a filename; if you hit such a limit reduce this number. The change simply shortens the reflection of the filename of the source file in the name given to the processed image. To avoid clashes, when a filename is shortened a random number is added to the shortened string.',
    'jcogs_img_cp_ce_image_remote_dir'                      => 'CE Image Remote Image Cache Directory',
    'jcogs_img_cp_ce_image_remote_dir_desc'                 => 'The directory used by CE Image to cache copies of remote images: if JCOGS Image cannot retrieve a remote image it will look for it in the CE Image remote image cache (if present) - while not a complete solution to missing remote images, this facility can help with site updates / migrations. Since the path needs to be one that is within your site\'s webroot JCOGS Image assumes that the a path entered here is <strong>relative to your webroot</strong>. <br>The default value is the default used by CE Image - i.e. <strong>images/remote</strong>.<br>To minimise potential problems with JCOGS Image (and other add-ons) please also ensure that your <strong><a href=\'/cp/settings/urls\' target=\'_blank\'>EE \'default base path\'</a></strong> is set correctly.',
    'jcogs_cp_ee_base_path_invalid'                         => 'The EE Base Path setting for your site appears to be invalid. Please check this setting for your site and try again ...',
    'jcogs_img_cp_ce_image_remote_dir_after_desc'           => 'The CE Image Remote Cache path that you entered does not appear to exist. Please check your entry and try again with a valid path.',
    'jcogs_img_cp_default_min_php_ram'                      => 'Minimum requested php memory (MB)',
    'jcogs_img_cp_default_min_php_ram_desc'                 => 'Enter a mminimum size for requested php memory allocation: if currently allocated memory is greater than this nothing will change, if less the add-on will <strong>temporarily</strong> request the specified higher amount from php. Increase this value if your server reports exceeding its memory usage limits - when such happens image processing will fail and may halt the EE system too (resulting in users seeing the "White Screen of Death"). The default value of 64 (Mbytes) is usually ample for most web purposes.',
    'jcogs_img_cp_default_min_php_process_time'             => 'Minimum requested php execution time (seconds)',
    'jcogs_img_cp_default_min_php_process_time_desc'        => 'Enter a minimum execution time limit to request from php: if currently allocated minimum execution time is greater than this nothing will change, if less the add-on will <strong>temporarily</strong> request the specified higher amount from php. Increase this value if your server reports exceeding its execution time limits - when such happens image processing will fail and may halt the EE system too (resulting in users seeing the "White Screen of Death"). The default value of 30 (seconds) is usually ample for most web purposes. Requesting a value of 0 prevents php from timing out.',
    'jcogs_img_cp_default_php_remote_connect_time'          => 'Minimum remote connection time (seconds)',
    'jcogs_img_cp_default_php_remote_connect_time_desc'     => 'Enter a minimum duration for remote connections to request from php. If this value is too low your server may not have time to complete retrieval of large images from slow internet locations. Increase this value if your JCOGS Image debug log reports that remote image retrievals are failing due to connection timeout. The default value of 3 (seconds) is usually ample for most web purposes.',
    'jcogs_img_cp_default_user_agent_string'                => 'User agent string to use for remote file retrieval',
    'jcogs_img_cp_default_user_agent_string_desc'           => 'Specify a user-agent string to report to remote servers when retriveing images from remote locations on the web. The default value works well for most web purposes.',
    'jcogs_img_cp_user_agent_string'                        => 'The user agent string you entered does not appear to be valid. Please try again with a valid version.',

    // Module Error Messages
    'jcogs_img_setup_is_invalid'                            => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Your server setup does not meet the <a href="https://jcogs.net/documentation/jcogs_img#jcogs-image-requirements" target="_blank">operational requirements for JCOGS Image</a> - please investigate and correct. Processing halted.', 
    'jcogs_img_save_path_missing'                           => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Something weird has happened to your image save path ... please report this to JCOGS Design (img_support@jcogs.net) so it can be investigated further. Thanks! ',
    'jcogs_img_svg_save_failed'                             => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Unable to copy SVG to cache directory ... please report this to JCOGS Design (img_support@jcogs.net) so it can be investigated further. Thanks! ',
    'jcogs_img_gd_library_not_found'                        => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> GD library not found, so giving up... ',
    'jcogs_img_invalid_ee_version'                          => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Invalid EE version detected so giving up... ',
    'jcogs_img_invalid_php_version'                         => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Invalid php version detected so giving up... ',
    'jcogs_img_no_src_image_supplied_2'                       => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> No src= parameter found. ',
    'jcogs_img_bulk_no_source'                              => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> No src= parameter found. ',
    'jcogs_img_no_backup_image_supplied'                    => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> No valid image source found, so giving up... ',
    'jcogs_img_file_not_an_image'                           => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> File provided does not appear to be an image file.',
    'jcogs_img_too_large_to_process'                        => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> File provided is too large to process - try again with a smaller image file, or adjust limit (in Image/Advanced Settings. Size of file read: ',
    'jcogs_img_local_copy_failed'                           => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Unable to open local copy of image file, processing abandoned for: ',
    'jcogs_img_type_not_recognised'                         => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Format of source image file is one that is not supported by this server. Image format found: ',
    'jcogs_img_exif_imagetype_not_recognised'               => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Format code for source image file reported by exif() is one that is not recognised. ',
    'jcogs_img_type_not_supported_by_destination_browser'   => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Selected file format is valid but does not appear to be supported by destination browser, using jpg instead.',
    'jcogs_img_source_not_valid'                            => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> The image supplied is not valid.',
    'jcogs_img_adding_border_failed'                        => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> The border parameter supplied is not valid.',
    'jcogs_img_invalid_aspect_ratio'                        => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> The aspect ratio supplied is not valid.',
    'jcogs_img_XSS_fail'                                    => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> The path provided failed XSS check.',
    'jcogs_img_unable_to_open_path_retry'                   => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Unable to confirm presence of source image, retrying using different method.',
    'jcogs_img_unable_to_open_path_1'                       => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Unable to read the image from a local path.',
    'jcogs_img_unable_to_open_path_2'                       => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Image path given is reported invalid by EE (ee("Filesystem")->exists).',
    'jcogs_img_unable_to_open_path_3'                       => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Unable to read image normally from remote path, trying again with slightly less secure method which sometimes works...',
    'jcogs_img_unable_to_open_path_5'                       => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Unable to read image from remote path given',
    'jcogs_img_open_path_config_issue'                      => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> There appears to be a configuration error relating to SSL and the php file_get_contents() function on your server.',
    'jcogs_img_working_file_save_failed'                    => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Unable to save working copy of image file.',
    'jcogs_img_browser_image_support_no_info_from_browser'  => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Browser failed to send an ACCEPT_HTTP header - so having to guess image support... ',
    'jcogs_img_exceeds_source'                              => '<span style="color:var(--ee-warning-dark);font-weight:bold">Note:</span> Requested operation would require image to rescaled to be larger than the original image and the \'allow_scale_larger\' parameter not set ... so staying with original size.',
    'jcogs_img_mask_shape_param_invalid'                    => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Parameter given for mask shape is invalid... ',
    'jcogs_img_rounded_corners_unknown_option'              => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Parameter given for rounded corner is invalid... ignoring parameter ...  ',
    'jcogs_img_rounded_corners_invalid_radius'              => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Parameter given for rounded corner radius is invalid... ignoring parameter ...  ',
    'jcogs_img_border_param_issue'                          => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Parameter given for border is invalid... ignoring parameter ...  ',
    'jcogs_img_mask_border_no_mask'                         => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Problem passing mask to border method. Skipping border add ...  ',
    'jcogs_img_mask_border_cannot_scale_mask'               => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Problem scaling mask in border method. Skipping border add ...  ',
    'jcogs_img_mask_border_cannot_set_background_colour'    => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Problem setting background colour in border method. Skipping border add ...  ',
    'jcogs_img_unable_to_convert_to_image'                  => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Unable to convert source to an image. Abandoning this src ...  ',
    'jcogs_img_unsharp_mask_failed'                         => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Unable to apply unsharp mask. Abandoning this filter ...  ',
    'jcogs_img_pixelate_failed'                             => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Unable to apply pixelate. Abandoning this filter ...  ',
    'jcogs_img_imagefilter_failed'                          => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Unknown filter, so baling out...',
    'jcogs_img_unknown_image_format'                        => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Processed image format requested has unknown mime type ... setting to blank.',
    'jcogs_img_cache_path_not_found'                        => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Cache_dir proposed (%s) cannot be found nor created. Reverting to default cache path.',
    'jcogs_img_heic_error'                                  => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Something went wrong with HEIC processing. The error reported was ',
    'jcogs_img_imagine_error'                               => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Something went wrong with Imagine Library processing. The error reported was ',
    'jcogs_img_box_width_adjusted_to_zero'                  => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Your tag includes an instruction for text-box width adjustment that reduces this width to zero px! No point continuing ... baling out',
    'jcogs_img_not_enough_dimensions_for_colour_field'      => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Colour field fallback requires both width and height to be specified for target image.',
    'jcogs_img_srcset_no_source_image'                      => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Trying to process srcset instructions but have no processed image to work with! Please contact support@jcogs.net with details to resolve.',
    'jcogs_img_face_detect_too_few_params'                  => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Face detect started with too few parameters defined. Baling out ... ',
    'jcogs_img_filter_queue_failed'                         => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> Something went wrong when applying the chosen filters! Baling out ... ',
    'jcogs_img_crop_exceeds_source'                         => '<span style="color:var(--ee-error);font-weight:bold">Error:</span> You are trying to create a crop that is larger than the image provided. Not sure what to do ... so baling ... ',

    // Utility Messages
    'jcogs_img_start'                                       => 'Image processing started.',
    'jcogs_img_memory_uplift'                               => 'Requesting server to increase in allocated memory (in Mbytes) for php use - from / to: ',
    'jcogs_img_restore_memory'                              => 'Requesting server to restore allocated memory (in Mbytes) for php use to: ',
    'jcogs_img_process_time_uplift'                         => 'Requesting server to increase in maximum execution time (in seconds) for php use - from / to: ',
    'jcogs_img_restore_process_time'                        => 'Requesting server to restore maximum execution time (in seconds) to: ',
    'jcogs_img_found_image'                                 => 'Found a valid image for processing: ',
    'jcogs_img_bulk_processing_start'                       => 'Bulk image processing started on:',
    'jcogs_img_bulk_processing_no_images_found'             => 'No images found in enclosed text, ending without doing anything.',
    'jcogs_img_bulk_excluding_image'                        => 'Excluding image due to exclude_regex tag: ',
    'jcogs_img_bulk_found_lazy_swap'                        => 'Found lazy-load image, swapping in original: ',
    'jcogs_img_make_lazy '                                  => 'Generating a lazy load image for: ',
    'jcogs_img_attempting_to_get'                           => 'Working with: ',
    'jcogs_img_processing_end'                              => 'End. %s',
    'jcogs_img_no_src_image_supplied'                       => '<strong>src</strong> is not a valid image. Trying the fallback_src.',
    'jcogs_img_no_fallback_image_supplied'                  => '<strong>fallback_src</strong> is not a valid image. Trying the default backup options.',
    'jcogs_img_no_image_fallback_option'                    => 'No valid default fallback image option found.',
    'jcogs_img_no_fallback_image_specified'                 => '<strong>fallback_src</strong> not specified. Trying the default backup options.',
    'jcogs_img_no_image_supplied_using_colour_field_backup' => 'Using colour field option in place of src image',
    'jcogs_img_no_image_supplied_using_remote_default'      => 'Using nominated remote image as src',
    'jcogs_img_no_image_supplied_using_local_default'       => 'Using nominated local image as src',
    'jcogs_gffl_started'                                    => 'Image is local: retrieving ',
    'jcogs_img_server_gd_response'                          => 'GD capabilities reported by server: ',
    'jcogs_img_server_capabilities'                         => 'Image write formats supported by this server: ',
    'jcogs_img_browser_user_agent_string'                   => 'Unable to get image capabilities from HTTP_ACCEPT information so trying USER_AGENT.',
    'jcogs_img_browser_image_support'                       => 'Image formats supported by this browser: ',
    'jcogs_img_image_validated'                             => 'Image validated OK: ',
    'jcogs_img_rescaled_due_to_dimension_limit'             => 'Non-zero Image dimension limit set and exceeded, rescaling image so longest axis reduced to: ',
    'jcogs_img_using_cache_mode'                            => 'Cache mode selected: ',
    'jcogs_img_slow_cache_option'                           => 'Slow cache mode selected',
    'jcogs_img_found_in_cache'                              => 'Copy of processed image found in cache. ',
    'jcogs_img_cache_disabled'                              => 'Cache disabled via options so making new image.',
    'jcogs_img_not_found_in_cache'                          => 'No cache copy so making new image: ',
    'jcogs_img_cropping_image_start'                        => 'Cropping image with params: ',
    'jcogs_img_cropping_image_smart_scale'                  => 'Smart scale crop requires image to be resized, using following dimensions: ',
    'jcogs_img_resizing_image'                              => 'Resizing image with params: ',
    'jcogs_img_flipping_image'                              => 'Flipping image with params: ',
    'jcogs_img_rotating_image'                              => 'Rotating image by: ',
    'jcogs_img_reflecting_image'                            => 'Reflecting image with params: ',
    'jcogs_img_adding_border'                               => 'Adding border to image with parameters: ',
    'jcogs_img_adding_rounded_corners'                      => 'Adding rounded corners to the image with parameters: ',
    'jcogs_img_adding_text_overlay'                         => 'Adding a text overlay to the image with parameters: ',
    'jcogs_img_too_small_to_add_text_overlay'               => 'Image is smaller than minimum size criteria so not adding the text overlay',
    'jcogs_img_adding_text_overlay_complete'                => 'Finished adding the a text overlay.',
    'jcogs_img_adding_watermark'                            => 'Adding a watermark to the image with parameters: ',
    'jcogs_img_adding_watermark_end'                        => 'Watermark added.',
    'jcogs_img_too_small_to_add_watermark'                  => 'Image is smaller than minimum size criteria so not adding the watermark',
    'jcogs_img_watermark_source_not_valid'                  => 'The watermark image supplied is not a valid image.',
    'jcogs_img_watermark_position_error'                    => 'The watermark horizontal and vertical positions specified are not recognised.',
    'jcogs_img_watermark_repeat_requested'                  => 'Repeat type watermark requested with parameters: ',
    'jcogs_img_saving_image_as'                             => 'Saving image as: ',
    'jcogs_img_saved'                                       => 'Image saved - file operation took: %0.4f seconds',
    'jcogs_img_post_processing_image'                       => 'Post-processing image data',
    'jcogs_img_post_processed'                              => 'Post-processing operation took: %0.4f seconds',
    'jcogs_img_generating_output'                           => 'Generating tag outputs',
    'jcogs_img_generating_full_urls'                        => 'Due to setting, generated tags will use full URLs to reference processed images.',
    'jcogs_img_generated_output'                            => 'Generating tag outputs operation took: %0.4f seconds',
    'jcogs_img_face_detect_start'                           => 'Beginning Face Detection, Sensitivity = %s',
    'jcogs_img_face_detect_ends'                            => 'Face detection operation successful - finding took: %0.4f seconds',
    'jcogs_img_face_detect'                                 => 'Face detection found %d faces',
    'jcogs_img_face_detect_none_found'                      => 'Face detection found no faces. Try increasing face_detect_sensitivity parameter? Operation took: %0.4f seconds',
    'jcogs_img_filtering_image_start'                       => 'Filtering image with: ',
    'jcogs_img_filtering_image_params'                      => ' Parameters: ',
    'jcogs_img_mask_draw_circle'                            => 'Mask Filter - drawing star mask: ',
    'jcogs_img_mask_draw_star'                              => 'Mask Filter - drawing star mask: ',
    'jcogs_img_mask_draw_polygon'                           => 'Mask Filter - drawing polygon mask: ',
    'jcogs_img_mask_unknown_shape'                          => 'Mask Filter - giving up - unknown shape specified: ',
    'jcogs_img_aspect_ratio_calc'                           => 'Aspect Ratio calculated: ',
    'jcogs_img_srcset_begin'                                => 'Adding srcset elements to img tag based on these parameters: ',
    'jcogs_img_srcset_generate_image'                       => 'Suitable image not found in cache - generating ',
    'jcogs_img_srcset_noop'                                 => '<span style="color:var(--ee-accent-dark);font-weight:bold">Note:</span>The size of original image relative to srcset parameter values mean that no srcset additional images need to be generated. Baling out of this operation.',
    'jcogs_img_srcset_end'                                  => 'Adding srcset elements to img tag complete.',
    'jcogs_img_srcset_and_ASL'                              => 'Adjusting processed image width to match largets srcset parameter value if needed.',
    'jcogs_img_cache_audit_begin'                           => 'Beginning an audit of %s image cache(s).',
    'jcogs_img_cache_audit_end'                             => 'Ending image cache audit, %d files removed.',
    'preferences_updated_desc'                              => 'The changes you made have been saved.',
    'preferences_updated'                                   => 'Preferences Updated',
    'settings_save_error_desc'                              => 'Something went wrong; it was not possible to save your changes.',
    'settings_save_error'                                   => 'Settings Not Updated',
    'jcogs_img_svg_image_passthrough_enabled'               => 'SVG image found, SVG passthrough enabled, so doing some limited processing to generate output.',
    'jcogs_img_svg_image_passthrough_disabled'              => 'SVG image found, SVG passthrough is not enabled, so baling out.',
    'jcogs_img_object_processing_starts'                    => 'Core image processing starting',
    'jcogs_img_object_processing_ends'                      => 'Core image processing took %0.4f seconds',
    'jcogs_img_auto_adjust_active_dimensions'               => 'Auto-adjust active - re-scaling image to maximum dimension of %1$s px',
    'jcogs_img_auto_adjust_active_dimensions_failed'        => 'Auto-adjust failed to rescale image successfully, probably too large to process, baling out...',
    'jcogs_img_auto_adjust_active_size'                     => 'Auto-adjust active - re-scaling image to reduce image filesize to below %1$s MB',
    'jcogs_img_auto_adjust_active_success'                  => 'Auto-adjust succeeded: image to be used in processing has maximum dimension of %1$d px and adjusted filesize of %2$0.2f MB. Auto-adjust processing took %3$0.2f seconds.',
    'jcogs_img_auto_adjust_active_size_failed'              => 'Auto-adjust failed to rescale image successfully, probably too large to process, baling out...',
    'jcogs_img_heic_conversion'                             => 'HEIC format Image found, converting to JPG to allow subsequent processing',
    'jcogs_img_cp_auto_manage_would_have_fired'             => 'JCOGS Image Cache Auto-Manage',
    'jcogs_img_cp_auto_manage_would_have_fired_desc'        => '%1$d processed images based on this image are currently in the JCOGS Image cache.<br>Modifying this image may affect these processed images.<br>To have JCOGS Image automatically update its cache to reflect changes made to images in the Files system turn on JCOGS Image\'s <a href=\"ee(\'CP/URL\', \'addons/settings/jcogs_img\')\">Cache Auto-Manage feature.',

    // Jump Menu strings
    'jump_system_settings'                                  => 'System Settings',
    'jump_cache_settings'                                   => 'Cache Settings',
    'jump_image_settings'                                   => 'Image Settings',
    'jump_advanced_settings'                                => 'Advanced Settings',
    'jump_license_settings'                                 => 'License Settings',

    // Fly-out Menu strings
    'fly_system_settings'                                  => 'System Settings',
    'fly_cache_settings'                                   => 'Cache Settings',
    'fly_image_settings'                                   => 'Image Settings',
    'fly_advanced_settings'                                => 'Advanced Settings',
    'fly_license_settings'                                 => 'License',
    'fly_clear_cache'                                      => 'Clear Image Cache',

    // Public Messages
    ''                              => ''
];