/**
 * Image Module Lazy Load Javascript
 * @copyright  Copyright (c) 2021 - 2023 JCOGS Design
 * @license    https://jcogs.net/add-ons/jcogs_img/license.html
 */
function jcogs_lazyload() {

    var lazyloadThrottleTimeout, lazyloadImages;

    lazyloadImages = document.querySelectorAll("[data-ji-src]");

    if (lazyloadThrottleTimeout) {
        clearTimeout(lazyloadThrottleTimeout);
    }

    lazyloadThrottleTimeout = setTimeout(function () {
        var scrollTop = window.scrollY;
        lazyloadImages.forEach(function (img) {
            if (img.offsetTop < (window.innerHeight + scrollTop)) {
                img.src = img.dataset.jiSrc;
                img.removeAttribute('data-ji-src');
                if(typeof img.dataset.jiSrcset !== 'undefined') {
                    img.srcset = img.dataset.jiSrcset;
                    img.removeAttribute('data-ji-srcset');
                }
            }
        });
        if (lazyloadImages.length == 0) {
            document.removeEventListener("scroll", jcogs_lazyload);
            window.removeEventListener("resize", jcogs_lazyload);
            window.removeEventListener("orientationChange", jcogs_lazyload);
        }
    }, 20);
}

document.addEventListener("DOMContentLoaded", function () {
    var lazyloadImages;
    // remove noscript images
    document.querySelectorAll("noscript.ji__progenhlazyns").forEach(e => e.parentNode.removeChild(e));

    if ("IntersectionObserver" in window) {
        lazyloadImages = document.querySelectorAll("[data-ji-src]");
        var imageObserver = new IntersectionObserver(function (entries, observer) {
            entries.forEach(function (entry) {
                if (entry.isIntersecting) {
                    var image = entry.target;
                    image.src = image.dataset.jiSrc;
                    image.removeAttribute('data-ji-src');
                    if(typeof image.dataset.jiSrcset !== 'undefined') {
                        image.srcset = image.dataset.jiSrcset;
                        image.removeAttribute('data-ji-srcset');
                    }
                    imageObserver.unobserve(image);
                }
            });
        });

        lazyloadImages.forEach(function (image) {
            imageObserver.observe(image);
        });
    } else {
        document.addEventListener("scroll", jcogs_lazyload);
        window.addEventListener("resize", jcogs_lazyload);
        window.addEventListener("orientationChange", jcogs_lazyload);
    }
});