<?php

/**
 * JCOGS Image Filter
 * ==================
 * A Slow but Good Sepia Filter.
 * Turns an image into a Sepia equivalent
 * Uses a pixel based method (the one used by CE Image it seems)
 * From here: https://dyclassroom.com/image-processing-project/how-to-convert-a-color-image-into-sepia-image
 * 
 * @return object $image
 * 
 * CHANGELOG
 * 
 * 12/12/2022: 1.3      First release
 * 
 * =====================================================
 *
 * @category   ExpressionEngine Add-on
 * @package    JCOGS Image
 * @author     JCOGS Design <contact@jcogs.net>
 * @copyright  Copyright (c) 2021 - 2023 JCOGS Design
 * @license    https://jcogs.net/add-ons/jcogs_img/license.html
 * @version    1.3.21.1
 * @link       https://JCOGS.net/
 * @since      File available since Release 1.3
 */

namespace JCOGSDesign\Jcogs_img\Filters\Gd;

use Imagine\Filter\FilterInterface;
use Imagine\Image\ImageInterface;

/**
 * A Slow Sepia filter.
 */
class Sepia_slow implements FilterInterface
{
    /**
     * Constructs Slow Sepia filter.
     *
     */
    public function __construct()
    {
    }

    /**
     * {@inheritdoc}
     *
     * @see \Imagine\Filter\FilterInterface::apply()
     */
    public function apply(ImageInterface $image)
    {
        // Get the GDImage object
        $img = imagecreatefromstring($image->__toString());

        // Get image size
        $size = $image->getSize();

        for($row = 0; $row < $size->getHeight(); $row++) {
            // scan across the column each time
            for($col = 0; $col < $size->getWidth(); $col++) {
                // Get the colour in original
                $rgbOrig = imagecolorat($img, $col, $row);
                $rOrig = round((($rgbOrig >> 16) & 0xFF),0);
                $gOrig = round((($rgbOrig >>  8) & 0xFF),0);
                $bOrig = round( ($rgbOrig        & 0xFF),0);
                $aOrig = round( ($rgbOrig & 0x7F000000) >> 24,0);
                // Work out sepia version of pixel colours
                $rNew = round(min(max(0.393*$rOrig + 0.769*$gOrig + 0.189*$bOrig,0),255),0);
                $gNew = round(min(max(0.349*$rOrig + 0.686*$gOrig + 0.168*$bOrig,0),255),0);
                $bNew = round(min(max(0.272*$bOrig + 0.534*$bOrig + 0.131*$bOrig,0),255),0);
                // Write the sepia version of the colour back
                $pixCol = imagecolorallocatealpha($img, $rNew, $gNew, $bNew, $aOrig);
                imagesetpixel($img, $col, $row, $pixCol);;
            }
        }

        // Replace original image with updated image
        $image = ee('jcogs_img:ImageUtilities')->convert_GDImage_object_to_image($img);
        unset($img);
        unset($size);

        return $image;
    }
}
