<?php

if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

/**
 * Channel Videos Helper File
 *
 * @package         ChannelVideos
 * @version         2.2
 * @author          EEHarbor <help@eeharbor.com>
 * @copyright       Copyright (c) 2007-2010 Parscale Media <http://www.parscale.com>
 * @license         https://eeharbor.com/license/
 * @link            https://eeharbor.com
 */
class Channel_videos_helper
{
    private $package_name = 'channel_videos';
    public function __construct()
    {
        $this->site_id = ee()->config->item('site_id');
    }

    // ********************************************************************************* //

    //public function getRouterUrl($type='url', $method='actionGeneralRouter')
    public function getRouterUrl($type = 'url', $method = 'channel_videos_router')
    {
        // -----------------------------------------
        // Grab action_id
        // -----------------------------------------
        if (isset(ee()->session->cache[$this->package_name]['router_url'][$method]['action_id']) === false) {
            ee()->db->select('action_id');
            ee()->db->where('class', ucfirst($this->package_name));
            ee()->db->where('method', $method);
            $query = ee()->db->get('exp_actions');
            if ($query->num_rows() == 0) {
                return false;
            }

            $action_id = $query->row('action_id');
        } else {
            $action_id = ee()->session->cache[$this->package_name]['router_url'][$method]['action_id'];
        }

        // -----------------------------------------
        // Return FULL action URL
        // -----------------------------------------
        if ($type == 'url') {
            // Grab Site URL
            $url = ee()->functions->fetch_site_index(0, 0);
            if (defined('MASKED_CP') == false or MASKED_CP == false) {
                // Replace site url domain with current working domain
                $server_host = (isset($_SERVER['HTTP_HOST']) == true && $_SERVER['HTTP_HOST'] != false) ? $_SERVER['HTTP_HOST'] : $_SERVER['SERVER_NAME'];
                $url = preg_replace('#http\://(([\w][\w\-\.]*)\.)?([\w][\w\-]+)(\.([\w][\w\.]*))?\/#', "http://{$server_host}/", $url);
            }

            // Create new URL
            $ajax_url = $url . QUERY_MARKER . 'ACT=' . $action_id;
            // Config Overrife for action URLs?
            $config = ee()->config->item('credits');
            $over = isset($config['action_url']) ? $config['action_url'] : array();
            if (is_array($over) === true && isset($over[$method]) === true) {
                $url = $over[$method];
            }

            // Protocol Relative URL
            $ajax_url = str_replace(array('https://', 'http://'), '//', $ajax_url);
            return $ajax_url;
        }

        return $action_id;
    }

    // ********************************************************************************* //

    /**
     * Grab File Module Settings
     * @return array
     */
    public function grab_settings($site_id = false)
    {
        $settings = array();
        if (isset(ee()->session->cache['channel_videos']['settings']) == true) {
            $settings = ee()->session->cache['channel_videos']['settings'];
        } else {
            ee()->db->select('settings');
            ee()->db->where('module_name', 'Channel_videos');
            $query = ee()->db->get('exp_modules');
            if ($query->num_rows() > 0 && $query->row('settings') !== null) {
                $settings = unserialize($query->row('settings'));
            }
        }

        ee()->session->cache['channel_videos']['settings'] = $settings;
        if ($site_id) {
            $settings = isset($settings['site:' . $site_id]) ? $settings['site:' . $site_id] : array();
        }

        if (isset($settings['players']['youtube']) == true) {
            //All of these are now depricated
            unset($settings['players']['youtube']['list']);
            unset($settings['players']['youtube']['playlist']);
            unset($settings['players']['youtube']['listType']);
        }

        return $settings;
    }

    // ********************************************************************************* //

    /**
     * Generate new XID
     *
     * @return string the_xid
     */
    public function xid_generator()
    {
        // Maybe it's already been made by EE
        if (defined('XID_SECURE_HASH') == true) {
            return XID_SECURE_HASH;
        }

        // First is secure_forum enabled?
        if (ee()->config->item('secure_forms') == 'y') {
            // Did we already cache it?
            if (isset(ee()->session->cache['XID']) == true && ee()->session->cache['XID'] != false) {
                return ee()->session->cache['XID'];
            }

            // Is there one already made that i can use?
            ee()->db->select('hash');
            ee()->db->from('exp_security_hashes');
            ee()->db->where('ip_address', ee()->input->ip_address());
            ee()->db->where('`date` > UNIX_TIMESTAMP()-3600');
            ee()->db->limit(1);
            $query = ee()->db->get();
            if ($query->num_rows() > 0) {
                $row = $query->row();
                ee()->session->cache['XID'] = $row->hash;
                return ee()->session->cache['XID'];
            }

            // Lets make one then!
            $XID    = ee()->functions->random('encrypt');
            ee()->db->insert('exp_security_hashes', array('date' => ee()->localize->now, 'ip_address' => ee()->input->ip_address(), 'hash' => $XID));
            // Remove Old
            //$DB->query("DELETE FROM exp_security_hashes WHERE date < UNIX_TIMESTAMP()-7200"); // helps garbage collection for old hashes

            ee()->session->cache['XID'] = $XID;
            return $XID;
        }
    }

    // ********************************************************************************* //

    /**
     * Format tags
     *
     * Cleans up the tag, by removing unwanted characters
     *
     * @param string $str[optional] - The unformatted tag
     * @return string The formatted tag
     */
    public function format_tag($str = '')
    {
        global $DB, $PREFS, $REGX;
        ee()->load->helper('text');
        $not_allowed = array('$', '?', ')', '(', '!', '<', '>', '/', '\\');
        $str = str_replace($not_allowed, '', $str);
        //$str    = ( $this->convert_case === true ) ? $this->_strtolower( $str ): $str;

        if (ee()->config->item('auto_convert_high_ascii') == 'y') {
            $str    =  ascii_to_entities($str);
        }

        $str    = ee()->security->xss_clean($str);
        return trim($str);
    }

    // ********************************************************************************* //

    /**
     * Insert Tag in DB
     *
     * @param string $tag - The tag
     * @return int - The tag ID
     */
    public function create_tag($tag)
    {
        global $DB, $LOC, $SESS;
        // Data array for insertion
        $data = array(  'tag_name'  =>  $tag,
                        'site_id'   =>  $this->site_id,
                        'author_id' =>  ee()->session->userdata['member_id'],
                        'entry_date' =>  ee()->localize->now,
                        'edit_date' =>  ee()->localize->now,
                        'total_entries' => 0,
                );
        ee()->db->insert('exp_points', $data);
        return ee()->db->insert_id();
    }

    // ********************************************************************************* //

    /**
     * Url Safe Tag
     *
     * This method is responsible for encode/decode tags for URL's
     *
     * @param string $tag - The original Tag
     * @param bool $encode[optional] - Are we encoding or decoding
     * @return string - The processed Tag
     */
    public function urlsafe_tag($tag, $encode = true)
    {
        // We atleast need a default..
        if (isset($this->settings['urlsafe_seperator']) == false) {
            $this->settings['urlsafe_seperator'] = 'plus';
        }

        if ($encode == true) {
            switch ($this->settings['urlsafe_seperator']) {
                case 'plus':
                                                                      $tag = str_replace(' ', '+', $tag);

                    break;
                case 'dash':
                                                                      $tag = str_replace(' ', '-', $tag);

                    break;
                case 'underscore':
                                                                      $tag = str_replace(' ', '_', $tag);

                    break;
            }

            $tag = str_replace(' ', '%20', $tag);
            $tag = htmlentities($tag, ENT_QUOTES, 'UTF-8');
        } else {
            switch ($this->settings['urlsafe_seperator']) {
                case 'plus':
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  $tag = str_replace('+', ' ', $tag);

                    break;
                case 'dash':
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  $tag = str_replace('-', ' ', $tag);

                    break;
                case 'underscore':
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  $tag = str_replace('_', ' ', $tag);

                    break;
            }

            $tag = str_replace('%20', ' ', $tag);
            $tag = html_entity_decode($tag);
        }

        return $tag;
    }

    // ********************************************************************************* //

    public function generate_json($obj)
    {
        if (function_exists('json_encode') === false) {
            if (class_exists('Services_JSON_CUSTOM') === false) {
                include dirname(__FILE__) . '/JSON.php';
            }
            $JSON = new Services_JSON_CUSTOM();
            return $JSON->encode($obj);
        } else {
            return json_encode($obj);
        }
    }

    // ********************************************************************************* //

    public function decode_json($obj)
    {
        if (function_exists('json_decode') === false) {
            if (class_exists('Services_JSON_CUSTOM') === false) {
                include dirname(__FILE__) . '/JSON.php';
            }
            $JSON = new Services_JSON_CUSTOM();
            return $JSON->decode($obj);
        } else {
            return json_decode($obj);
        }
    }

    // ********************************************************************************* //

    /**
     * Is a Natural number  (0,1,2,3, etc.)
     *
     * @access  public
     * @param   string
     * @return  bool
     */
    public function is_natural_number($str)
    {
        return (bool)preg_match('/^[0-9]+$/', $str);
    }

    // ********************************************************************************* //

    public function parse_keywords($str, $remove = array())
    {
        // Remove all whitespace except single space
        $str = preg_replace("/(\r\n|\r|\n|\t|\s)+/", ' ', $str);
        // Characters that we do not want to allow...ever.
        // In the EE cleaner, we lost too many characters that might be useful in a Custom Field search, especially with Exact Keyword searches
        // The trick, security-wise, is to make sure any keywords output is converted to entities prior to any possible output
        $chars = array( '{' ,
                        '}' ,
                        "^" ,
                        "~" ,
                        "*" ,
                        "|" ,
                        "[" ,
                        "]" ,
                        '?' . '>' ,
                        '<' . '?' ,
                      );
        // Keep as a space, helps prevent string removal security holes
        $str = str_replace(array_merge($chars, $remove), ' ', $str);
        // Only a single single space for spaces
        $str = preg_replace("/\s+/", ' ', $str);
        // Kill naughty stuff
        $str = trim(ee()->security->xss_clean($str));
        return $str;
    }

    // ********************************************************************************* //

    /**
     * Fetch URL with file_get_contents or with CURL
     *
     * @param string $url
     * @return mixed
     */
    public function fetch_url_file($url, $user = false, $pass = false)
    {
        $data = '';
        /** --------------------------------------------
                /**  cURL
                /** --------------------------------------------*/

        if (function_exists('curl_init') === true && ($ch = @curl_init()) !== false) {
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            //if ( ! ini_get('safe_mode') && ! ini_get('open_basedir')) curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
            curl_setopt($ch, CURLOPT_USERAGENT, @$_SERVER['HTTP_HOST'] . ' Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.5) Gecko/2008120122 Firefox/3.0.5 (.NET CLR 3.5.30729)');
            if ($user != false) {
                curl_setopt($ch, CURLOPT_USERPWD, "$user:$pass");
                if (defined('CURLOPT_HTTPAUTH')) {
                    curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
                }
            }

            //exit($url);
            $data = curl_exec($ch);
            curl_close($ch);
            if ($data !== false) {
                return trim($data);
            }
        }

        /** --------------------------------------------
        /**  file_get_contents()
        /** --------------------------------------------*/

        if ((bool) @ini_get('allow_url_fopen') !== false && $user == false) {
            if ($data = @file_get_contents($url)) {
                return trim($data);
            }
        }

        /** --------------------------------------------
        /**  fsockopen() - Last but only slightly least...
        /** --------------------------------------------*/

        $parts  = parse_url($url);
        $host   = $parts['host'];
        $path   = (!isset($parts['path'])) ? '/' : $parts['path'];
        $port   = ($parts['scheme'] == "https") ? '443' : '80';
        $ssl    = ($parts['scheme'] == "https") ? 'ssl://' : '';
        if (isset($parts['query']) && $parts['query'] != '') {
            $path .= '?' . $parts['query'];
        }

        $fp = @fsockopen($ssl . $host, $port, $error_num, $error_str, 7);
        if (is_resource($fp)) {
            fputs($fp, "GET " . $path . " HTTP/1.0\r\n");
            fputs($fp, "Host: " . $host . "\r\n");
            fputs($fp, "User-Agent: Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.2.1)\r\n");
            if ($user != false) {
                fputs($fp, "Authorization: Basic " . base64_encode("$user:$pass") . "\r\n");
            }

            fputs($fp, "Connection: close\r\n\r\n");
            $header = '';
            $body   = '';
            /* ------------------------------
               /*  This error suppression has to do with a PHP bug involving
              /*  SSL connections: http://bugs.php.net/bug.php?id=23220
                /* ------------------------------*/

            $old_level = error_reporting(0);
            /*
                while ( ! feof($fp))
               {
                  $data .= trim(fgets($fp, 128));
                }
                */

            // put the header in variable $header
            do { // loop until the end of the header
                $header .= fgets($fp, 128);
            } while (strpos($header, "\r\n\r\n") === false);
            // now put the body in variable $body
            while (! feof($fp)) {
                $body .= fgets($fp, 128);
            }

            error_reporting($old_level);
            $data = $body;
            fclose($fp);
        }

        return trim($data);
    }

    // ********************************************************************************* //

    public function tstamptotime($tstamp)
    {

        // converts ISODATE to unix date
        // 1984-09-01T14:21:31Z
        sscanf($tstamp, "%u-%u-%uT%u:%u:%uZ", $year, $month, $day, $hour, $min, $sec);
        $newtstamp = mktime($hour, $min, $sec, $month, $day, $year);
        return $newtstamp;
    }

    // ********************************************************************************* //

    /**
     * Function for looking for a value in a multi-dimensional array
     *
     * @param string $value
     * @param array $array
     * @return bool
     */
    public function in_multi_array($value, $array)
    {
        foreach ($array as $key => $item) {
            // Item is not an array
            if (!is_array($item)) {
                // Is this item our value?
                if ($item == $value) {
                    return true;
                }
            } else {
                // Item is an array
                // See if the array name matches our value
                //if ($key == $value) return true;

                // See if this array matches our value
                if (in_array($value, $item)) {
                    return true;
                } elseif ($this->in_multi_array($value, $item)) {
                    // Search this array
                    return true;
                }
            }
        }

        // Couldn't find the value in array
        return false;
    }

    // ********************************************************************************* //

    /**
     * Get Entry_ID from tag paramaters
     *
     * Supports: entry_id="", url_title="", channel=""
     *
     * @return mixed - INT or BOOL
     */
    public function get_entry_id_from_param($get_channel_id = false)
    {
        $entry_id = false;
        $channel_id = false;
        ee()->load->helper('number');
        if (ee()->TMPL->fetch_param('entry_id') != false && $this->is_natural_number(ee()->TMPL->fetch_param('entry_id')) != false) {
            $entry_id = ee()->TMPL->fetch_param('entry_id');
        } elseif (ee()->TMPL->fetch_param('url_title') != false) {
            $channel = false;
            $channel_id = false;
            if (ee()->TMPL->fetch_param('channel') != false) {
                $channel = ee()->TMPL->fetch_param('channel');
            }

            if (ee()->TMPL->fetch_param('channel_id') != false && $this->is_natural_number(ee()->TMPL->fetch_param('channel_id'))) {
                $channel_id = ee()->TMPL->fetch_param('channel_id');
            }

            ee()->db->select('exp_channel_titles.entry_id');
            ee()->db->select('exp_channel_titles.channel_id');
            ee()->db->from('exp_channel_titles');
            if ($channel) {
                ee()->db->join('exp_channels', 'exp_channel_titles.channel_id = exp_channels.channel_id', 'left');
            }
            ee()->db->where('exp_channel_titles.url_title', ee()->TMPL->fetch_param('url_title'));
            if ($channel) {
                ee()->db->where('exp_channels.channel_name', $channel);
            }
            if ($channel_id) {
                ee()->db->where('exp_channel_titles.channel_id', $channel_id);
            }
            ee()->db->limit(1);
            $query = ee()->db->get();
            if ($query->num_rows() > 0) {
                $channel_id = $query->row('channel_id');
                $entry_id = $query->row('entry_id');
                $query->free_result();
            } else {
                return false;
            }
        }

        if ($get_channel_id != false) {
            if (ee()->TMPL->fetch_param('channel') != false) {
                $channel_id = ee()->TMPL->fetch_param('channel_id');
            }

            if ($channel_id == false) {
                ee()->db->select('channel_id');
                ee()->db->where('entry_id', $entry_id);
                ee()->db->limit(1);
                $query = ee()->db->get('exp_channel_titles');
                $channel_id = $query->row('channel_id');
                $query->free_result();
            }

            $entry_id = array( 'entry_id' => $entry_id, 'channel_id' => $channel_id );
        }



        return $entry_id;
    }

    // ********************************************************************************* //

    /**
     * Custom No_Result conditional
     *
     * Same as {if no_result} but with your own conditional.
     *
     * @param string $cond_name
     * @param string $source
     * @param string $return_source
     * @return unknown
     */
    public function custom_no_results_conditional($cond_name, $source, $return_source = false)
    {
        if (strpos($source, LD . "if {$cond_name}" . RD) !== false) {
            if (preg_match('/' . LD . "if {$cond_name}" . RD . '(.*?)' . LD . '\/' . 'if' . RD . '/s', $source, $cond)) {
                return $cond[1];
            }
        }

        if ($return_source !== false) {
            return $source;
        }

        return;
    }

    // ********************************************************************************* //

    /**
     * Fetch data between var pairs
     *
     * @param string $open - Open var (with optional parameters)
     * @param string $close - Closing var
     * @param string $source - Source
     * @return string
     */
    public function fetch_data_between_var_pairs($varname = '', $source = '')
    {
        if (! preg_match('/' . LD . ($varname) . RD . '(.*?)' . LD . '\/' . $varname . RD . '/s', $source, $match)) {
            return;
        }

        return $match['1'];
    }

    // ********************************************************************************* //

    /**
     * Fetch data between var pairs (including optional parameters)
     *
     * @param string $open - Open var (with optional parameters)
     * @param string $close - Closing var
     * @param string $source - Source
     * @return string
     */
    public function fetch_data_between_var_pairs_params($open = '', $close = '', $source = '')
    {
        if (! preg_match('/' . LD . preg_quote($open) . '.*?' . RD . '(.*?)' . LD . '\/' . $close . RD . '/s', $source, $match)) {
            return;
        }

        return $match['1'];
    }

    // ********************************************************************************* //

    /**
     * Replace var_pair with final value
     *
     * @param string $open - Open var (with optional parameters)
     * @param string $close - Closing var
     * @param string $replacement - Replacement
     * @param string $source - Source
     * @return string
     */
    public function swap_var_pairs($varname = '', $replacement = '\\1', $source = '')
    {
        return preg_replace("/" . LD . $varname . RD . "(.*?)" . LD . '\/' . $varname . RD . "/s", $replacement, $source);
    }

    // ********************************************************************************* //

    /**
     * Replace var_pair with final value (including optional parameters)
     *
     * @param string $open - Open var (with optional parameters)
     * @param string $close - Closing var
     * @param string $replacement - Replacement
     * @param string $source - Source
     * @return string
     */
    public function swap_var_pairs_params($open = '', $close = '', $replacement = '\\1', $source = '')
    {
        return preg_replace("/" . LD . preg_quote($open) . RD . "(.*?)" . LD . '\/' . $close . RD . "/s", $replacement, $source);
    }

    // ********************************************************************************* //

    public function formatDate($format = '', $date = 0, $localize = true)
    {
        if (method_exists(ee()->localize, 'format_date') === true) {
            return ee()->localize->format_date($format, $date, $localize);
        } else {
            return ee()->localize->decode_date($format, $date, $localize);
        }
    }

    // ********************************************************************************* //

    public function getThemeUrl($root = false)
    {
        if (defined('URL_THIRD_THEMES') === true) {
            $theme_url = URL_THIRD_THEMES;
        } else {
            $theme_url = ee()->config->item('theme_folder_url') . 'third_party/';
        }

        $theme_url = str_replace(array('http://','https://'), '//', $theme_url);
        if ($root) {
            return $theme_url;
        }

        $theme_url .= $this->package_name . '/';
        return $theme_url;
    }

    // ********************************************************************************* //

    public function addMcpAssets($type = '', $path = '', $package = '', $name = '', $iecond = false)
    {
        $theme_url = $this->getThemeUrl();
        $url = $this->getThemeUrl() . $path;
        $prefix = ($iecond) ? "<!--[if {$iecond}]>" : '';
        $suffix = ($iecond) ? '<![endif]-->' : '';
        // CSS
        if ($type == 'css') {
            if (isset(ee()->session->cache['css'][$package][$name]) === false) {
                ee()->cp->add_to_head($prefix . '<link rel="stylesheet" href="' . $url . '" type="text/css" media="print, projection, screen" />' . $suffix);
                ee()->session->cache['css'][$package][$name] = true;
            }
        }

        // JS
        if ($type == 'js') {
            if (isset(ee()->session->cache['javascript'][$package][$name]) === false) {
                ee()->cp->add_to_foot($prefix . '<script src="' . $url . '" type="text/javascript"></script>' . $suffix);
                ee()->session->cache['javascript'][$package][$name] = true;
            }
        }

        // Custom
        if ($type == 'custom') {
            $path = str_replace('{theme_url}', $theme_url, $path);
            ee()->cp->add_to_foot($path);
        }

        // Global Inline Javascript
        if ($type == 'gjs') {
            if (isset(ee()->session->cache['inline_js'][$this->package_name]) == false) {
                $ACT_url = $this->getRouterUrl('url');
                /*
                    if (isset(ee()->updater->settings['action_url']['actionGeneralRouter']) === true && ee()->updater->settings['action_url']['actionGeneralRouter'] != false) {
                        $ACT_url = ee()->updater->settings['action_url']['actionGeneralRouter'];
                    }*/

                // Remove those AMP!!!
                $ACT_url = str_replace('&amp;', '&', $ACT_url);
                $theme_url = str_replace('&amp;', '&', $theme_url);
                $module_settings = $this->grab_settings($this->site_id);
                $vimeo_api_key = @$module_settings['players']['vimeo']['api_key'];
                if ($vimeo_api_key !== null && !trim($vimeo_api_key)) {
                    $vimeo_api_key = "87bf1c0e8001f77858ee407e00513f20";
                }
                $js = "
    var ChannelVideos = ChannelVideos ? ChannelVideos : {};
    ChannelVideos.ACT_URL = '{$ACT_url}';
    ChannelVideos.THEME_URL = '{$theme_url}';
    ChannelVideos.VIMEO_ACCESS_TOKEN = '" . $vimeo_api_key . "';
";
                ee()->cp->add_to_foot('<script type="text/javascript">' . $js . '</script>');
                ee()->session->cache['inline_js'][$this->package_name] = true;
            }
        }
    }

    // ********************************************************************************* //
}
// END CLASS

/* End of file shop_helper.php  */
/* Location: ./system/user/addons/points/modules/libraries/shop_helper.php */
